/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.render;

import java.util.ArrayList;
import net.fexcraft.lib.mc.api.registry.fTESR;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.block.generated.BlockTileEntity;
import net.fexcraft.mod.fvtm.data.Capabilities;
import net.fexcraft.mod.fvtm.data.block.Block;
import net.fexcraft.mod.fvtm.data.block.BlockData;
import net.fexcraft.mod.fvtm.model.DebugModels;
import net.fexcraft.mod.fvtm.model.RenderCache;
import net.fexcraft.mod.fvtm.model.content.BlockModel;
import net.fexcraft.mod.fvtm.render.SeparateRenderCache;
import net.fexcraft.mod.fvtm.util.TexUtil;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import org.lwjgl.opengl.GL11;

@fTESR
public class BaseBlockRenderer
extends TileEntitySpecialRenderer<BlockTileEntity> {
    private BlockData data = null;
    private BlockModel model = null;

    public void render(BlockTileEntity tile, double posX, double posY, double posZ, float partialticks, int destroystage, float f) {
        if (Config.RENDER_BLOCKS_SEPARATELY) {
            return;
        }
        this.data = tile.getBlockData();
        if (this.data == null) {
            return;
        }
        if (((Block)this.data.getType()).getAABBs().containsKey("render")) {
            return;
        }
        this.model = (BlockModel)((Block)this.data.getType()).getModel();
        if (this.model == null) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)(posX + 0.5), (double)posY, (double)(posZ + 0.5));
            DebugModels.SPHERE_RED.render(0.5f);
            GL11.glPopMatrix();
            return;
        }
        SeparateRenderCache.SORTED_BLK_ENTITY.add(tile);
        SeparateRenderCache.SORTED_BLK_DATA.add(tile.getBlockData());
        GL11.glPushMatrix();
        GL11.glTranslated((double)(posX + 0.5), (double)posY, (double)(posZ + 0.5));
        TexUtil.bindTexture(this.model.bindtex ? this.data.getCurrentTexture() : FvtmRegistry.WHITE_TEXTURE);
        GL11.glPushMatrix();
        GL11.glRotated((double)((Block)this.data.getType()).getBlockType().getRotationFor(tile.func_145832_p()), (double)0.0, (double)1.0, (double)0.0);
        if (this.model.rootrender) {
            this.model.render(BlockModel.RENDERDATA.set(this.data, tile, null).rc((RenderCache)tile.getCapability(Capabilities.RENDERCACHE, null)));
        }
        if (this.model.state_models.size() > 0) {
            IBlockState state = tile.func_145831_w().func_180495_p(tile.func_174877_v());
            for (IProperty prop : tile.func_145838_q().func_176194_O().func_177623_d()) {
                String str = prop.func_177701_a() + "=" + state.func_177229_b(prop);
                if (!this.model.state_models.containsKey(str)) continue;
                ArrayList<BlockModel> list = this.model.state_models.get(str);
                for (BlockModel statemodel : list) {
                    statemodel.render(BlockModel.RENDERDATA);
                }
            }
        }
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }
}

