/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.render;

import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.mod.fvtm.data.Capabilities;
import net.fexcraft.mod.fvtm.data.Decoration;
import net.fexcraft.mod.fvtm.data.DecorationData;
import net.fexcraft.mod.fvtm.entity.DecorationEntity;
import net.fexcraft.mod.fvtm.item.DecorationItem;
import net.fexcraft.mod.fvtm.model.DefaultModel;
import net.fexcraft.mod.fvtm.model.RenderCache;
import net.fexcraft.mod.fvtm.render.RenderView;
import net.fexcraft.mod.fvtm.util.DebugUtils;
import net.fexcraft.mod.fvtm.util.TexUtil;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.world.EntityW;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class DecorationRenderer {
    public static void renderDecorations(World world, double cx, double cy, double cz, float partialticks) {
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (Entity ent : world.field_72996_f) {
            if (!(ent instanceof DecorationEntity) || !RenderView.FRUSTUM.func_78546_a(ent.func_174813_aQ())) continue;
            DecorationEntity deco = (DecorationEntity)ent;
            EntityW ew = UniEntity.getEntityN((Object)ent);
            GL11.glPushMatrix();
            GL11.glTranslated((double)(ent.field_70165_t - cx), (double)(ent.field_70163_u - cy), (double)(ent.field_70161_v - cz));
            if (deco.decos.size() == 0) {
                DecorationRenderer.rencube();
            } else {
                if (Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b() instanceof DecorationItem) {
                    DecorationRenderer.rencube();
                }
                RenderCache cache = (RenderCache)ent.getCapability(Capabilities.RENDERCACHE, null);
                for (DecorationData data : deco.decos) {
                    if (((Decoration)data.getType()).getModel() == null) {
                        DebugUtils.renderBB(0.25f, DebugUtils.COL_CYN);
                        continue;
                    }
                    int i = DecorationRenderer.getBrightness(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
                    int j = i % 65536;
                    int k = i / 65536;
                    OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)j / 1.0f), (float)((float)k / 1.0f));
                    GL11.glPushMatrix();
                    data.offset.translate();
                    if (data.roty != 0.0f) {
                        GL11.glRotatef((float)data.roty, (float)0.0f, (float)1.0f, (float)0.0f);
                    }
                    if (data.rotz != 0.0f) {
                        GL11.glRotatef((float)data.rotz, (float)0.0f, (float)0.0f, (float)1.0f);
                    }
                    if (data.rotx != 0.0f) {
                        GL11.glRotatef((float)data.rotx, (float)1.0f, (float)0.0f, (float)0.0f);
                    }
                    if (data.sclx != 1.0f || data.scly != 1.0f || data.sclz != 1.0f) {
                        GL11.glScalef((float)data.sclx, (float)data.scly, (float)data.sclz);
                    }
                    TexUtil.bindTexture(data.getTexture().getTexture());
                    ((Decoration)data.getType()).getModel().render(DefaultModel.RENDERDATA.set(data, ew).rc(cache));
                    GL11.glPopMatrix();
                }
            }
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    private static void rencube() {
        GL11.glTranslatef((float)0.0f, (float)0.25f, (float)0.0f);
        DebugUtils.renderBB(0.5f, DebugUtils.COL_CYN);
        GL11.glTranslatef((float)0.0f, (float)-0.25f, (float)0.0f);
        RGB.glColorReset();
    }

    public static int getBrightness(double x, double y, double z) {
        BlockPos.MutableBlockPos mutblk = new BlockPos.MutableBlockPos(MathHelper.func_76128_c((double)x), 0, MathHelper.func_76128_c((double)z));
        if (Minecraft.func_71410_x().field_71441_e.func_175667_e((BlockPos)mutblk)) {
            mutblk.func_185336_p(MathHelper.func_76128_c((double)y));
            return Minecraft.func_71410_x().field_71441_e.func_175626_b((BlockPos)mutblk, 0);
        }
        return 0;
    }
}

