/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.render;

import net.fexcraft.mod.fvtm.data.Sign;
import net.fexcraft.mod.fvtm.data.SignData;
import net.fexcraft.mod.fvtm.data.ToolboxType;
import net.fexcraft.mod.fvtm.item.SignItem;
import net.fexcraft.mod.fvtm.item.ToolboxItem;
import net.fexcraft.mod.fvtm.model.DefaultModel;
import net.fexcraft.mod.fvtm.model.RenderCache;
import net.fexcraft.mod.fvtm.render.DecorationRenderer;
import net.fexcraft.mod.fvtm.sys.sign.SignInstance;
import net.fexcraft.mod.fvtm.sys.sign.SignSystem;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.sys.uni.SystemRegion;
import net.fexcraft.mod.fvtm.util.DebugUtils;
import net.fexcraft.mod.fvtm.util.GLUtils112;
import net.fexcraft.mod.fvtm.util.TexUtil;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class SignRenderer {
    private static SignSystem sys;
    private static boolean holding;

    public static void renderSigns(World world, double cx, double cy, double cz, float ticks) {
        sys = (SignSystem)SystemManager.get(SystemManager.Systems.SIGN, WrapperHolder.getWorld((Object)world));
        if (sys == null) {
            return;
        }
        holding = Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b() instanceof ToolboxItem && Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77952_i() == ToolboxType.SIGN_ADJREM.idx;
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (SystemRegion reg : sys.getRegions().values()) {
            for (SignInstance sign : reg.getObjects().values()) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)(sign.vec.vec.x - cx), (double)(sign.vec.vec.y - cy), (double)(sign.vec.vec.z - cz));
                if (sign.components.size() == 0) {
                    DebugUtils.renderBB(0.5f, DebugUtils.COL_CYN);
                } else {
                    if (holding || Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b() instanceof SignItem) {
                        DebugUtils.renderBB(0.5f, DebugUtils.COL_CYN);
                    }
                    RenderCache cache = sign.getRenderCache();
                    GL11.glRotatef((float)sign.yaw, (float)0.0f, (float)1.0f, (float)0.0f);
                    for (SignData scom : sign.components) {
                        if (((Sign)scom.getType()).getModel() == null) {
                            DebugUtils.renderBB(0.25f, DebugUtils.COL_RED);
                            continue;
                        }
                        int i = DecorationRenderer.getBrightness(sign.vec.pos.x, sign.vec.pos.y, sign.vec.pos.z);
                        int j = i % 65536;
                        int k = i / 65536;
                        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)j / 1.0f), (float)((float)k / 1.0f));
                        GL11.glPushMatrix();
                        GLUtils112.translate(scom.offset);
                        if (scom.roty != 0.0f) {
                            GL11.glRotatef((float)scom.roty, (float)0.0f, (float)1.0f, (float)0.0f);
                        }
                        if (scom.rotz != 0.0f) {
                            GL11.glRotatef((float)scom.rotz, (float)0.0f, (float)0.0f, (float)1.0f);
                        }
                        if (scom.rotx != 0.0f) {
                            GL11.glRotatef((float)scom.rotx, (float)1.0f, (float)0.0f, (float)0.0f);
                        }
                        if (scom.sclx != 1.0f || scom.scly != 1.0f || scom.sclz != 1.0f) {
                            GL11.glScalef((float)scom.sclx, (float)scom.scly, (float)scom.sclz);
                        }
                        TexUtil.bindTexture(scom.getTexture().getTexture());
                        ((Sign)scom.getType()).getModel().render(DefaultModel.RENDERDATA.set(scom, sign).rc(cache));
                        GL11.glPopMatrix();
                    }
                }
                GL11.glPopMatrix();
            }
        }
        GL11.glPopMatrix();
    }
}

