/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.render;

import java.util.ArrayList;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.block.generated.BlockTileEntity;
import net.fexcraft.mod.fvtm.data.Capabilities;
import net.fexcraft.mod.fvtm.data.block.Block;
import net.fexcraft.mod.fvtm.model.RenderCache;
import net.fexcraft.mod.fvtm.model.content.BlockModel;
import net.fexcraft.mod.fvtm.render.RenderView;
import net.fexcraft.mod.fvtm.render.SeparateRenderCache;
import net.fexcraft.mod.fvtm.util.DebugUtils;
import net.fexcraft.mod.fvtm.util.TexUtil;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class TileRenderer {
    private static final ArrayList<TileEntity> entities = new ArrayList();
    private static AxisAlignedBB box;

    public static void renderBlocks(World world, double cx, double cy, double cz, float ticks) {
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        entities.clear();
        entities.addAll(world.field_147482_g);
        for (TileEntity entity : entities) {
            if (!(entity instanceof BlockTileEntity)) continue;
            BlockTileEntity tile = (BlockTileEntity)entity;
            if (!Config.RENDER_BLOCKS_SEPARATELY && !((Block)tile.getBlockData().getType()).getAABBs().containsKey("render") || !RenderView.FRUSTUM.func_78546_a((box = (AxisAlignedBB)((Block)tile.getBlockData().getType()).getAABB("render", "").get(0)).func_186670_a(tile.func_174877_v()))) continue;
            SeparateRenderCache.SORTED_BLK_ENTITY.add(tile);
            SeparateRenderCache.SORTED_BLK_DATA.add(tile.getBlockData());
            GL11.glPushMatrix();
            GL11.glTranslated((double)((double)tile.func_174877_v().func_177958_n() - cx + 0.5), (double)((double)tile.func_174877_v().func_177956_o() - cy), (double)((double)tile.func_174877_v().func_177952_p() - cz + 0.5));
            GL11.glRotated((double)((Block)tile.getBlockData().getType()).getBlockType().getRotationFor(tile.func_145832_p()), (double)0.0, (double)1.0, (double)0.0);
            float i = TileRenderer.getBrightness(tile.func_174877_v());
            float j = i % 65536.0f;
            float k = i / 65536.0f;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
            RenderCache cache = (RenderCache)tile.getCapability(Capabilities.RENDERCACHE, null);
            BlockModel model = (BlockModel)((Block)tile.getBlockData().getType()).getModel();
            if (model != null) {
                GL11.glPushMatrix();
                TexUtil.bindTexture(tile.getBlockData().getCurrentTexture());
                if (model.rootrender) {
                    model.render(BlockModel.RENDERDATA.set(tile.getBlockData(), tile, null).rc(cache));
                }
                if (model.state_models.size() > 0) {
                    IBlockState state = tile.func_145831_w().func_180495_p(tile.func_174877_v());
                    for (IProperty prop : tile.func_145838_q().func_176194_O().func_177623_d()) {
                        String str = prop.func_177701_a() + "=" + state.func_177229_b(prop);
                        if (!model.state_models.containsKey(str)) continue;
                        ArrayList<BlockModel> list = model.state_models.get(str);
                        for (BlockModel statemodel : list) {
                            statemodel.render(BlockModel.RENDERDATA);
                        }
                    }
                }
                GL11.glPopMatrix();
            } else {
                TexUtil.bindTexture(tile.getBlockData().getCurrentTexture());
                DebugUtils.SPHERE.render();
            }
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    @Deprecated
    public static int getBrightness(BlockPos pos) {
        if (Minecraft.func_71410_x().field_71441_e.func_175667_e(pos)) {
            return Minecraft.func_71410_x().field_71441_e.func_175626_b(pos, 0);
        }
        return 0;
    }
}

