/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.render;

import java.util.ArrayList;
import java.util.Map;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.frl.Renderer;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.block.generated.JACK_TE;
import net.fexcraft.mod.fvtm.data.Capabilities;
import net.fexcraft.mod.fvtm.data.InteractZone;
import net.fexcraft.mod.fvtm.data.block.BlockType;
import net.fexcraft.mod.fvtm.data.block.JackEntity;
import net.fexcraft.mod.fvtm.data.part.Part;
import net.fexcraft.mod.fvtm.data.part.PartData;
import net.fexcraft.mod.fvtm.data.vehicle.SwivelPoint;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.model.DebugModels;
import net.fexcraft.mod.fvtm.model.DefaultModel;
import net.fexcraft.mod.fvtm.model.Model;
import net.fexcraft.mod.fvtm.model.RenderCache;
import net.fexcraft.mod.fvtm.render.EffectRenderer;
import net.fexcraft.mod.fvtm.render.RenderView;
import net.fexcraft.mod.fvtm.render.SeparateRenderCache;
import net.fexcraft.mod.fvtm.sys.uni.RootVehicle;
import net.fexcraft.mod.fvtm.sys.uni.VehicleInstance;
import net.fexcraft.mod.fvtm.util.Command;
import net.fexcraft.mod.fvtm.util.DebugUtils;
import net.fexcraft.mod.fvtm.util.GLUtils112;
import net.fexcraft.mod.fvtm.util.TexUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class VehicleRenderer {
    private static final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, 0, 0);
    private static final ArrayList<Entity> entities = new ArrayList();
    private static SeparateRenderCache.SepVehCache sepcache;
    private static AxisAlignedBB box;
    private static float ran;
    private static V3D iz;

    public static void renderVehicles(World world, double cx, double cy, double cz, float ticks) {
        if (!Config.RENDER_VEHICLES_SEPARATELY) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        entities.clear();
        entities.addAll(world.field_72996_f);
        for (Entity entity : entities) {
            if (!(entity instanceof RootVehicle)) continue;
            RootVehicle vehicle = (RootVehicle)entity;
            if (vehicle.vehicle.data == null) continue;
            if (vehicle.vehicle.cache == null) {
                vehicle.vehicle.cache = (RenderCache)vehicle.getCapability(Capabilities.RENDERCACHE, null);
            }
            sepcache = vehicle.vehicle.cache.get(SeparateRenderCache.SEP_VEH_CACHE, data -> new SeparateRenderCache.SepVehCache());
            double x = vehicle.field_70142_S + (vehicle.field_70165_t - vehicle.field_70142_S) * (double)ticks;
            double y = vehicle.field_70137_T + (vehicle.field_70163_u - vehicle.field_70137_T) * (double)ticks;
            double z = vehicle.field_70136_U + (vehicle.field_70161_v - vehicle.field_70136_U) * (double)ticks;
            if (!VehicleRenderer.inView(vehicle, x, y, z)) {
                // empty if block
            }
            GL11.glTranslated((double)(x - cx), (double)(y - cy), (double)(z - cz));
            if (Command.OTHER) {
                for (SwivelPoint point : vehicle.vehicle.data.getRotationPoints().values()) {
                    V3D vec = point.getRelativeVector(0.0, 0.1f, 0.0);
                    GL11.glTranslated((double)vec.x, (double)vec.y, (double)vec.z);
                    DebugModels.SPHERE_GRY.render(0.5f);
                    GL11.glTranslated((double)(-vec.x), (double)(-vec.y), (double)(-vec.z));
                }
            }
            GL11.glPushMatrix();
            V3D rot = EffectRenderer.getRotations(vehicle, ticks);
            GL11.glRotated((double)(-rot.x), (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)rot.y, (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)rot.z, (double)0.0, (double)0.0, (double)1.0);
            sepcache.set(x, y, z, rot);
            int i = VehicleRenderer.getBrightness(x, y, z);
            int j = i % 65536;
            int k = i / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)j / 1.0f), (float)((float)k / 1.0f));
            GL11.glPushMatrix();
            Model vehmod = ((Vehicle)vehicle.vehicle.data.getType()).getModel();
            if (vehmod != null) {
                GL11.glPushMatrix();
                TexUtil.bindTexture(vehicle.vehicle.data.getCurrentTexture());
                vehmod.render(DefaultModel.RENDERDATA.set(vehicle.vehicle, ticks).rc(vehicle.vehicle.cache));
                GL11.glPopMatrix();
            } else {
                TexUtil.bindTexture(vehicle.vehicle.data.getCurrentTexture());
                DebugModels.SPHERE_RED.render(0.5f);
            }
            EffectRenderer.renderVehicleInfo(vehicle.vehicle, vehicle.vehicle.entity.getPos(), vehicle.vehicle.data);
            GL11.glPopMatrix();
            if (vehicle.vehicle.data.getParts().size() > 0) {
                VehicleRenderer.renderPoint(vehicle.vehicle.point, vehicle, vehicle.vehicle.data, vehicle.vehicle.cache, ticks);
            }
            GL11.glPopMatrix();
            VehicleRenderer.renderDetachedPoints(vehicle, vehicle.vehicle.data, vehicle.vehicle.cache, ticks);
            EffectRenderer.renderToggableInfo(vehicle, vehicle.vehicle.data);
            EffectRenderer.renderSeatsAndInvs(vehicle.vehicle);
            GL11.glTranslated((double)(-x + cx), (double)(-y + cy), (double)(-z + cz));
        }
        GL11.glPopMatrix();
    }

    private static boolean inView(RootVehicle ent, double x, double y, double z) {
        for (InteractZone value : ent.vehicle.data.getInteractZones().values()) {
            iz = value.pos(ent.vehicle.data).add(x, y, z);
            ran = value.range;
            box = new AxisAlignedBB(VehicleRenderer.iz.x - (double)ran, VehicleRenderer.iz.y - (double)ran, VehicleRenderer.iz.z - (double)ran, VehicleRenderer.iz.x + (double)ran, VehicleRenderer.iz.y + (double)ran, VehicleRenderer.iz.z + (double)ran);
            if (!RenderView.FRUSTUM.func_78546_a(box)) continue;
            return true;
        }
        return false;
    }

    public static void renderPoint(SwivelPoint point, RootVehicle vehicle, VehicleData data, RenderCache cache, float ticks) {
        if (point.detached) {
            return;
        }
        ArrayList<Map.Entry<String, PartData>> parts = data.sorted_parts.get(point.id);
        if (parts == null) {
            return;
        }
        GL11.glPushMatrix();
        if (!point.isVehicle()) {
            V3D temp0 = point.getPos();
            V3D temp1 = point.getPrevPos();
            V3D temp2 = new V3D(temp1.x + (temp0.x - temp1.x) * (double)ticks, temp1.y + (temp0.y - temp1.y) * (double)ticks, temp1.z + (temp0.z - temp1.z) * (double)ticks);
            GL11.glTranslated((double)temp2.x, (double)temp2.y, (double)temp2.z);
            V3D rot = EffectRenderer.getRotations(point, ticks);
            GL11.glRotated((double)(-rot.x), (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)(-rot.y), (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)(-rot.z), (double)0.0, (double)0.0, (double)1.0);
        }
        for (Map.Entry<String, PartData> entry : parts) {
            TexUtil.bindTexture(entry.getValue().getCurrentTexture());
            GLUtils112.translate(entry.getValue().getInstalledPos());
            entry.getValue().getInstalledRot().rotate112();
            ((Part)entry.getValue().getType()).getModel().render(DefaultModel.RENDERDATA.set(data, vehicle == null ? null : vehicle.vehicle, entry.getValue(), entry.getKey(), ticks).rc(cache));
            entry.getValue().getInstalledRot().rotate112R();
            GLUtils112.translateR(entry.getValue().getInstalledPos());
        }
        for (SwivelPoint sub : point.subs) {
            VehicleRenderer.renderPoint(sub, vehicle, data, cache, ticks);
        }
        GL11.glPopMatrix();
    }

    public static void renderDetachedPoints(RootVehicle vehicle, VehicleData data, RenderCache cache, float ticks) {
        for (SwivelPoint point : vehicle.vehicle.point.subs) {
            ArrayList<Map.Entry<String, PartData>> parts;
            if (!point.detached || (parts = data.sorted_parts.get(point.id)) == null) continue;
            GL11.glPushMatrix();
            V3D temp0 = point.getRelativeVector(V3D.NULL);
            V3D temp1 = point.getPrevRelativeVector(V3D.NULL);
            V3D temp2 = new V3D(temp1.x + (temp0.x - temp1.x) * (double)ticks, temp1.y + (temp0.y - temp1.y) * (double)ticks, temp1.z + (temp0.z - temp1.z) * (double)ticks);
            GL11.glTranslated((double)temp2.x, (double)temp2.y, (double)temp2.z);
            V3D rot = EffectRenderer.getRotations(point, ticks);
            GL11.glRotated((double)(-rot.x), (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)(-rot.y), (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)(-rot.z), (double)0.0, (double)0.0, (double)1.0);
            for (Map.Entry<String, PartData> entry : parts) {
                TexUtil.bindTexture(entry.getValue().getCurrentTexture());
                GLUtils112.translate(entry.getValue().getInstalledPos());
                entry.getValue().getInstalledRot().rotate112();
                ((Part)entry.getValue().getType()).getModel().render(DefaultModel.RENDERDATA.set(data, vehicle == null ? null : vehicle.vehicle, entry.getValue(), entry.getKey(), ticks).rc(cache));
                entry.getValue().getInstalledRot().rotate112R();
                GLUtils112.translateR(entry.getValue().getInstalledPos());
            }
            for (SwivelPoint sub : point.subs) {
                VehicleRenderer.renderPoint(sub, vehicle, data, cache, ticks);
            }
            GL11.glPopMatrix();
        }
    }

    public static void renderPointSep(SwivelPoint point, VehicleInstance inst, ArrayList<String> parts, float ticks) {
        GL11.glPushMatrix();
        if (!point.isVehicle()) {
            V3D temp0 = point.getPos();
            V3D temp1 = point.getPrevPos();
            V3D temp2 = new V3D(temp1.x + (temp0.x - temp1.x) * (double)ticks, temp1.y + (temp0.y - temp1.y) * (double)ticks, temp1.z + (temp0.z - temp1.z) * (double)ticks);
            V3D rot = EffectRenderer.getRotations(point, ticks);
            GL11.glTranslated((double)temp2.x, (double)temp2.y, (double)temp2.z);
            GL11.glRotated((double)(-rot.x), (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)(-rot.y), (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)(-rot.z), (double)0.0, (double)0.0, (double)1.0);
        }
        for (Map.Entry<String, PartData> entry : inst.data.getParts().entrySet()) {
            if (!parts.contains(entry.getKey()) || !entry.getValue().isInstalledOnSwivelPoint(point.id)) continue;
            TexUtil.bindTexture(entry.getValue().getCurrentTexture());
            GLUtils112.translate(entry.getValue().getInstalledPos());
            entry.getValue().getInstalledRot().rotate112();
            ((Part)entry.getValue().getType()).getModel().getSeparateGroups().render(DefaultModel.RENDERDATA.set(inst.data, inst, entry.getValue(), entry.getKey(), ticks).rc(inst.cache).sep());
            entry.getValue().getInstalledRot().rotate112R();
            GLUtils112.translateR(entry.getValue().getInstalledPos());
        }
        for (SwivelPoint sub : point.subs) {
            VehicleRenderer.renderPointSep(sub, inst, parts, ticks);
        }
        GL11.glPopMatrix();
    }

    @Deprecated
    public static int getBrightness(double x, double y, double z) {
        pos.func_189532_c(x, y, z);
        if (Minecraft.func_71410_x().field_71441_e.func_175667_e((BlockPos)pos)) {
            return Minecraft.func_71410_x().field_71441_e.func_175626_b((BlockPos)pos, 0);
        }
        return 0;
    }

    public static void renderJacks(World world, double cx, double cy, double cz, float ticks) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-cx), (double)(-cy), (double)(-cz));
        for (Map.Entry<V3D, JackEntity> entry : SeparateRenderCache.JACKS.entrySet()) {
            JACK_TE jack = (JACK_TE)entry.getValue();
            if (jack.getVehicle() == null) continue;
            GL11.glPushMatrix();
            Renderer.RENDERER.translate(entry.getKey());
            GL11.glRotated((double)BlockType.GENERIC_4ROT.getRotationFor(jack.func_145832_p()), (double)0.0, (double)1.0, (double)0.0);
            int i = VehicleRenderer.getBrightness(entry.getKey().x, entry.getKey().y, entry.getKey().z);
            int j = i % 65536;
            int k = i / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)j / 1.0f), (float)((float)k / 1.0f));
            Model vehmod = ((Vehicle)jack.getVehicle().getType()).getModel();
            if (vehmod != null) {
                GL11.glPushMatrix();
                TexUtil.bindTexture(jack.getVehicle().getCurrentTexture());
                vehmod.render(DefaultModel.RENDERDATA.set(jack.getVehicle(), null, ticks).rc((RenderCache)jack.getCapability(Capabilities.RENDERCACHE, null)));
                GL11.glPopMatrix();
            } else {
                DebugUtils.renderBB(0.5f, RGB.RED.packed);
            }
            if (jack.getVehicle().getParts().size() > 0) {
                VehicleRenderer.renderPoint(jack.getVehicle().getRotationPoint("vehicle"), null, jack.getVehicle(), (RenderCache)jack.getCapability(Capabilities.RENDERCACHE, null), ticks);
            }
            EffectRenderer.renderVehicleInfo(null, entry.getKey(), jack.getVehicle());
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        SeparateRenderCache.JACKS.clear();
    }
}

