/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.render.block;

import java.util.ArrayList;
import net.fexcraft.lib.common.math.AxisRotator;
import net.fexcraft.lib.common.math.Vec3f;
import net.fexcraft.lib.mc.utils.Axis3DL;
import net.fexcraft.mod.fvtm.data.block.Block;
import net.fexcraft.mod.fvtm.model.DefaultModel;
import net.fexcraft.mod.fvtm.model.ModelGroup;
import net.fexcraft.mod.fvtm.model.Program;
import net.fexcraft.mod.fvtm.model.Transforms;
import net.fexcraft.mod.fvtm.model.content.BlockModel;
import net.fexcraft.mod.fvtm.render.block.FvtmBlockModelLoader;
import net.fexcraft.mod.fvtm.render.block.RoadLinesModelLoader;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;

public class BakedModelLoader {
    public static void register() {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)FvtmBlockModelLoader.getInstance());
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)RoadLinesModelLoader.INSTANCE);
    }

    public static ArrayList<ModelGroup> getPolygons(BlockModel model, IBlockState state, EnumFacing side, long rand) {
        ArrayList<ModelGroup> list = new ArrayList<ModelGroup>();
        for (ModelGroup group : model.groups) {
            if (group.has_pre_prog) {
                for (Program program : group.getPrePrograms()) {
                    program.pre(group, DefaultModel.RENDERDATA.set(null, null, state));
                }
            }
            if (!group.visible) continue;
            list.add(group);
        }
        return list;
    }

    public static void reset(BlockModel model, IBlockState state, EnumFacing side, long rand) {
        for (ModelGroup group : model.groups) {
            if (!group.has_pst_prog) continue;
            for (Program program : group.getPstPrograms()) {
                program.post(group, DefaultModel.RENDERDATA.set(null, null, state));
            }
        }
        model.bk = null;
    }

    public static void convertTransforms(BlockModel model, Block block, IBlockState state) {
        model.bk = new BlockModel.BakedTransformData();
        model.bk.rot_poly = new Axis3DL();
        model.bk.rot_meta = new Axis3DL();
        if (state != null) {
            model.bk.rot_meta.setAngles(-((float)block.getBlockType().getRotationFor(state.func_177230_c().func_176201_c(state))), 0.0f, 0.0f);
        }
        if (model.transforms.hasRotate()) {
            ArrayList<Transforms.TF_Rotate> list = model.transforms.getBakedRotate();
            model.bk.rot_tf = new AxisRotator[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Transforms.TF_Rotate rot = list.get(i);
                model.bk.rot_tf[i] = AxisRotator.newDefInstance();
                model.bk.rot_tf[i].setAngles(rot.y * rot.angle, rot.z * rot.angle, rot.x * rot.angle);
            }
        }
        model.bk.translate = model.transforms.hasTranslate() ? model.transforms.getBakedTranslate() : new Vec3f();
        model.bk.scale = model.transforms.hasScale() ? model.transforms.getBakedScale() : new Vec3f(1.0f, 1.0f, 1.0f);
        for (ArrayList<BlockModel> val : model.state_models.values()) {
            for (BlockModel v : val) {
                BakedModelLoader.convertTransforms(v, block, state);
            }
        }
    }
}

