/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.render.block;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import net.fexcraft.lib.mc.registry.NamedResourceLocation;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.data.block.Block;
import net.fexcraft.mod.fvtm.model.content.BlockModel;
import net.fexcraft.mod.fvtm.render.block.BakedModelImpl;
import net.fexcraft.mod.fvtm.render.block.FvtmBlockModelLoader;
import net.fexcraft.mod.uni.IDL;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

class ModelImpl
implements IModel {
    protected final ResourceLocation modelloc;
    protected BlockModel model;
    protected Block block;
    protected boolean ambocl;
    protected HashMap<NamedResourceLocation, TextureAtlasSprite> tex_sprites = new HashMap();
    protected ArrayList<NamedResourceLocation> textures;
    protected ArrayList<ResourceLocation> copy;
    protected TextureAtlasSprite particle;
    public static final IModelState default_state = new IModelState(){

        public Optional<TRSRTransformation> apply(Optional<? extends IModelPart> part) {
            return Optional.empty();
        }
    };

    public ModelImpl(ResourceLocation rs) {
        this.modelloc = rs;
        FvtmBlockModelLoader.MODELS.put(rs, this);
        String bid = rs.toString();
        if (bid.contains("/")) {
            bid = bid.split(":")[0] + ":" + bid.substring(bid.lastIndexOf("/"));
        }
        if (bid.contains("#")) {
            bid = bid.substring(0, bid.indexOf("#"));
        }
        this.block = FvtmRegistry.BLOCKS.get(bid);
        this.model = (BlockModel)this.block.getModel();
        this.ambocl = this.block.getModelData().getBoolean("AmbientOcclusion", false);
        this.getTexturesFromBlock();
    }

    private void getTexturesFromBlock() {
        ArrayList<NamedResourceLocation> list = new ArrayList<NamedResourceLocation>();
        for (IDL idl : this.block.getDefaultTextures()) {
            String path = idl.path();
            if (idl.path().startsWith("textures/")) {
                path = path.substring("textures/".length());
            }
            if (idl.path().endsWith(".png")) {
                path = path.substring(0, path.lastIndexOf("."));
            }
            list.add(new NamedResourceLocation(idl.name(), idl.space(), path));
        }
        if (list.size() == 0) {
            String str = this.modelloc.toString().replace("models/block", "block");
            if (str.contains(".")) {
                str = str.substring(0, str.indexOf("."));
            }
            list.add(new NamedResourceLocation("main;" + str));
        }
        this.textures = list;
        this.copy = new ArrayList<NamedResourceLocation>(this.textures);
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    public IModelState getDefaultState() {
        return default_state;
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> func) {
        for (NamedResourceLocation loc : this.textures) {
            this.tex_sprites.put(loc, func.apply((ResourceLocation)loc));
            if (!loc.getName().equals("particle")) continue;
            this.particle = this.tex_sprites.get(loc);
        }
        return new BakedModelImpl(this.modelloc, this, format, this.model);
    }

    public Collection<ResourceLocation> getTextures() {
        return this.copy;
    }

    public IModel process(ImmutableMap<String, String> data) {
        return this;
    }
}

