/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.render.block;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.fexcraft.app.json.JsonHandler;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.block.generated.FvtmProperties;
import net.fexcraft.mod.fvtm.block.generated.G_ROAD_LINES;
import net.fexcraft.mod.fvtm.block.generated.G_ROAD_MARKER4;
import net.fexcraft.mod.fvtm.block.generated.G_ROAD_PATTERN;
import net.fexcraft.mod.fvtm.data.block.Block;
import net.fexcraft.mod.fvtm.model.block.BakedQuadData;
import net.fexcraft.mod.fvtm.render.block.ModelImpl;
import net.fexcraft.mod.fvtm.render.block.OverrideList;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.IModelState;

public class RoadLinesModelLoader
implements ICustomModelLoader {
    public static RoadLinesModelLoader INSTANCE = new RoadLinesModelLoader();
    public static final Map<String, Block> BLOCKS = new HashMap<String, Block>();

    public void func_110549_a(IResourceManager resman) {
    }

    public boolean accepts(ResourceLocation loc) {
        String str = loc.toString();
        if (!str.contains("/") && !str.endsWith("#inventory")) {
            return BLOCKS.containsKey(str.split("#")[0]);
        }
        return BLOCKS.containsKey(str);
    }

    public IModel loadModel(ResourceLocation loc) throws Exception {
        return new LineModel(loc);
    }

    public static class LineModel
    implements IModel {
        protected List<ResourceLocation> texs = new ArrayList<ResourceLocation>();
        protected TextureAtlasSprite particle;
        protected TextureAtlasSprite sprite;
        protected ResourceLocation tex;
        protected ResourceLocation par;
        protected boolean ambocl;

        public LineModel(ResourceLocation rs) throws IOException {
            String bid = rs.toString();
            if (bid.contains("/")) {
                bid = bid.split(":")[0] + ":" + bid.substring(bid.lastIndexOf("/"));
            }
            if (bid.contains("#")) {
                bid = bid.substring(0, bid.indexOf("#"));
            }
            Block block = FvtmRegistry.BLOCKS.get(bid);
            this.ambocl = block.getModelData().getBoolean("AmbientOcclusion", false);
            Object[] str = FvtmResources.getAssetInputStreamWithFallback(block.getID().space() + ":models/block/" + block.getID().path() + ".json");
            JsonMap map = JsonHandler.parse((InputStream)((InputStream)str[0])).asMap().getMap("textures");
            this.tex = new ResourceLocation(map.getString("texture", "fvtm:block/asphalt"));
            this.par = new ResourceLocation(map.getString("particle", "fvtm:block/asphalt"));
            this.texs.add(this.tex);
            this.texs.add(this.par);
            for (int i = 1; i < str.length; ++i) {
                ((InputStream)str[i]).close();
            }
        }

        public Collection<ResourceLocation> getDependencies() {
            return Collections.emptyList();
        }

        public IModelState getDefaultState() {
            return ModelImpl.default_state;
        }

        public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> func) {
            this.sprite = func.apply(this.tex);
            this.particle = func.apply(this.par);
            return new BakedModel(this, format);
        }

        public Collection<ResourceLocation> getTextures() {
            return this.texs;
        }

        public IModel process(ImmutableMap<String, String> data) {
            return this;
        }
    }

    public static class BakedModel
    implements IBakedModel {
        private VertexFormat vertform;
        private LineModel root;

        public BakedModel(LineModel model, VertexFormat format) {
            this.vertform = format;
            this.root = model;
        }

        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            int hei = state == null ? 0 : (Integer)state.func_177229_b((IProperty)FvtmProperties.HEIGHT);
            boolean hl = state.func_177230_c() instanceof G_ROAD_LINES;
            Object uv = BakedQuadData.uv_full;
            if (hl) {
                int lines = (Integer)state.func_177229_b((IProperty)FvtmProperties.LINE_TYPE);
                int rot = (Integer)state.func_177229_b((IProperty)FvtmProperties.LINE_ROT);
                switch (lines) {
                    case 0: {
                        uv = BakedQuadData.uv_ls2[rot];
                        break;
                    }
                    case 1: {
                        uv = BakedQuadData.uv_lc2[rot];
                        break;
                    }
                    case 2: {
                        uv = BakedQuadData.uv_l3[rot];
                        break;
                    }
                    case 3: {
                        uv = BakedQuadData.uv_lf;
                    }
                }
            } else if (state.func_177230_c() instanceof G_ROAD_MARKER4) {
                EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)FvtmProperties.FACING);
                for (int i = 0; i < dir.func_176736_b(); ++i) {
                    uv = BakedQuadData.rotateL(uv);
                }
            } else if (state.func_177230_c() instanceof G_ROAD_PATTERN) {
                G_ROAD_PATTERN blk = (G_ROAD_PATTERN)state.func_177230_c();
                int x = (Integer)state.func_177229_b((IProperty)blk.prop_x);
                int z = (Integer)state.func_177229_b((IProperty)blk.prop_z);
                float us = 16.0f / (float)blk.texx;
                float vs = 16.0f / (float)blk.texz;
                uv = new double[][]{{us * (float)x + us, vs * (float)z}, {us * (float)x, vs * (float)z}, {us * (float)x, vs * (float)z + vs}, {us * (float)x + us, vs * (float)z + vs}};
                EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)FvtmProperties.FACING);
                uv = BakedQuadData.rotateU(uv);
                for (int i = 0; i < dir.func_176736_b(); ++i) {
                    uv = BakedQuadData.rotateL(uv);
                }
            }
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(this.vertform);
            builder.setContractUVs(true);
            builder.setQuadOrientation(EnumFacing.UP);
            builder.setTexture(this.root.sprite);
            this.putVertexData(builder, BakedQuadData.quad[0], hei, uv[0][0], uv[0][1]);
            this.putVertexData(builder, BakedQuadData.quad[1], hei, uv[1][0], uv[1][1]);
            this.putVertexData(builder, BakedQuadData.quad[2], hei, uv[2][0], uv[2][1]);
            this.putVertexData(builder, BakedQuadData.quad[3], hei, uv[3][0], uv[3][1]);
            quads.add((BakedQuad)builder.build());
            return quads;
        }

        private void putVertexData(UnpackedBakedQuad.Builder builder, double[] vec, int hei, double u, double v) {
            block5: for (int e = 0; e < this.vertform.func_177345_h(); ++e) {
                switch (this.vertform.func_177348_c(e).func_177375_c()) {
                    case POSITION: {
                        builder.put(e, new float[]{(float)vec[0], (float)(vec[1] - (double)((float)hei * 0.0625f)), (float)vec[2]});
                        continue block5;
                    }
                    case COLOR: 
                    case NORMAL: {
                        builder.put(e, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
                        continue block5;
                    }
                    case UV: {
                        builder.put(e, new float[]{this.root.sprite.func_94214_a(u), this.root.sprite.func_94207_b(v), 0.0f, 1.0f});
                        continue block5;
                    }
                    default: {
                        builder.put(e, new float[0]);
                    }
                }
            }
        }

        public boolean func_177555_b() {
            return this.root.ambocl;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.root.particle;
        }

        public ItemOverrideList func_188617_f() {
            return OverrideList.INSTANCE;
        }
    }
}

