/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.event;

import java.util.Arrays;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.mod.fvtm.sys.condition.Condition;
import net.fexcraft.mod.fvtm.sys.condition.ConditionRegistry;
import net.fexcraft.mod.fvtm.sys.event.EventAction;
import net.fexcraft.mod.fvtm.sys.event.EventType;

public class EventListener {
    public EventType type;
    public Condition cond;
    public EventAction action;
    public String[] args;

    public EventListener(JsonMap map) {
        this.type = EventType.parse(map.getString("type", "null"));
        this.cond = map.get("cond").isArray() ? new Condition(map.get("cond").asArray()) : ConditionRegistry.parse(map.getString("cond", "true"));
        this.cond.link();
        this.action = EventAction.parse(map.getString("action", "none"));
        this.args = map.has("args") ? (map.get("args").isArray() ? map.getArray("args").toStringArray() : map.get("args").string_value().split(" ")) : new String[0];
    }

    public EventListener(JsonArray arr) {
        this.type = EventType.parse(arr.get(0).string_value());
        this.cond = arr.get(1).isArray() ? new Condition(arr.get(1).asArray()) : ConditionRegistry.parse(arr.get(1).string_value());
        this.cond.link();
        this.action = EventAction.parse(arr.get(2).string_value());
        this.args = arr.size() > 3 ? (arr.get(3).isArray() ? arr.get(3).asArray().toStringArray() : arr.get(3).string_value().split(" ")) : new String[0];
    }

    public EventListener(String typ, String con, String act, String ... strs) {
        this.type = EventType.parse(typ);
        this.cond = ConditionRegistry.parse(con);
        this.cond.link();
        this.action = EventAction.parse(act);
        this.args = EventListener.parseArg(strs);
    }

    public static String[] parseArg(String ... args) {
        return args.length == 1 && args[0].contains(" ") ? args[0].split(" ") : args;
    }

    public static EventListener parse(JsonValue val) {
        if (val.isArray()) {
            return new EventListener(val.asArray());
        }
        if (val.isMap()) {
            return new EventListener(val.asMap());
        }
        String[] args = val.string_value().split(" ");
        return new EventListener(args[0], args[1].replace("-", " "), args[2], args.length > 3 ? Arrays.copyOfRange(args, 3, args.length) : new String[]{});
    }

    public String argString() {
        StringBuilder str = new StringBuilder();
        for (String arg : this.args) {
            if (str.length() > 0) {
                str.append(" " + arg);
                continue;
            }
            str.append(arg);
        }
        return str.toString();
    }
}

