/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.rail;

import java.util.ArrayList;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.sys.rail.Coupler;
import net.fexcraft.mod.fvtm.sys.rail.RailEntity;
import net.fexcraft.mod.fvtm.sys.rail.RailRegion;
import net.fexcraft.mod.fvtm.sys.rail.RailSystem;
import net.fexcraft.mod.fvtm.sys.rail.Track;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.tag.TagLW;

public abstract class Compound {
    public static final TreeMap<Long, Compound> COMPOUNDS = new TreeMap();
    protected float accumulator;
    protected ArrayList<RailEntity> entities = new ArrayList();
    public boolean forward;
    protected final long uid;
    protected Track last_stop;
    protected double last_stop_passed;

    public Compound(long uid) {
        this.uid = uid;
    }

    public abstract boolean isHead(RailEntity var1);

    public abstract boolean isEnd(RailEntity var1);

    public abstract RailEntity getHead();

    public abstract RailEntity getEnd();

    public abstract boolean isSingular();

    public abstract boolean isMultiple();

    public abstract int getIndex(RailEntity var1);

    public abstract int size();

    public long getUID() {
        return this.uid;
    }

    public static Compound get(RailEntity ent, long uid) {
        if (COMPOUNDS.containsKey(uid)) {
            return COMPOUNDS.get(uid);
        }
        return new Singular(ent, uid);
    }

    public static Compound getNewClientCompound(RailEntity entity) {
        long id = COMPOUNDS.size();
        while (COMPOUNDS.containsKey(id)) {
            ++id;
        }
        FvtmLogger.debug((Object)("Creating new placeholder client compound for '" + entity.uid + "'/" + id + "!"));
        return new Singular(entity, id);
    }

    public ArrayList<RailEntity> getEntitites() {
        return this.entities;
    }

    protected void stop(Track track, double pass) {
        if (this.last_stop == null || this.last_stop != track) {
            for (RailEntity ent : this.entities) {
                ent.vehicle.throttle = 0.0;
            }
        }
        this.last_stop = track;
        this.last_stop_passed = pass;
    }

    protected abstract boolean isActive();

    protected void dispose() {
        COMPOUNDS.remove(this.uid);
    }

    protected abstract boolean getOrient(RailEntity var1);

    public <V> void forEachMirror(boolean head, V value, Consumer<V> flip, Consumer<V> pass, BiConsumer<RailEntity, V> process) {
        Coupler coupler;
        if (this.isSingular()) {
            return;
        }
        RailEntity ent = this.entities.get(head ? 0 : this.entities.size() - 1);
        Coupler coupler2 = coupler = ent.front.hasEntity() ? ent.rear : ent.front;
        while (coupler.getOpposite().hasEntity()) {
            if ((coupler = coupler.getOpposite()).isFrontal() ? coupler.isFront() : coupler.isRear()) {
                flip.accept(value);
            } else {
                pass.accept(value);
            }
            coupler = coupler.getCounterpart();
            if (coupler.root == ent) continue;
            process.accept(coupler.root, value);
        }
    }

    public static class Multiple
    extends Compound {
        public Multiple(RailEntity root, RailEntity entity) {
            super(root.region.getSystem().getNewCompoundId());
            this.entities.add(root);
            this.entities.add(entity);
            COMPOUNDS.put(this.uid, this);
        }

        public Multiple(Compound recom, int start, int end) {
            super(recom.entities.get((int)start).region.getSystem().getNewCompoundId());
            for (int i = start; i < end; ++i) {
                this.entities.add(recom.entities.get(i));
            }
            for (RailEntity ent : this.entities) {
                ent.com = this;
            }
            COMPOUNDS.put(this.uid, this);
        }

        public Multiple(RailSystem system, RailRegion region, Long id, TagLW list) {
            super(id);
            RailEntity prev = null;
            for (TagCW compound : list) {
                if (compound == null) continue;
                if (!compound.has("region")) {
                    return;
                }
                if (FvtmRegistry.VEHICLES.get(compound.getString("Vehicle")) == null) {
                    FvtmLogger.log((Object)("COMPOUND(" + id + ") Rail Vehicle with id '" + compound.getString("Vehicle") + "' not found, removing."));
                    FvtmLogger.log((Object)("NBT:" + compound));
                    continue;
                }
                RailEntity curr = new RailEntity(region == null ? (RailRegion)system.getRegions().getC(compound.getIntArray("region"), false) : region, this).read(compound);
                if (curr == null) continue;
                if (prev != null) {
                    if (compound.has("front_coupled") && compound.getLong("front_coupled") == prev.uid) {
                        (compound.getBoolean((String)"front_coupler") ? prev.front : prev.rear).entity = curr;
                        curr.front.entity = prev;
                    } else if (compound.has("rear_coupled") && compound.getLong("rear_coupled") == prev.uid) {
                        (compound.getBoolean((String)"rear_coupler") ? prev.front : prev.rear).entity = curr;
                        curr.rear.entity = prev;
                    }
                }
                prev = curr;
                this.entities.add(prev);
            }
            if (this.entities.isEmpty()) {
                return;
            }
            COMPOUNDS.put(this.uid, this);
        }

        @Override
        public boolean isHead(RailEntity root) {
            return ((RailEntity)this.entities.get((int)0)).uid == root.uid;
        }

        @Override
        public boolean isEnd(RailEntity root) {
            return ((RailEntity)this.entities.get((int)(this.size() - 1))).uid == root.uid;
        }

        @Override
        public RailEntity getHead() {
            return (RailEntity)this.entities.get(0);
        }

        @Override
        public RailEntity getEnd() {
            return (RailEntity)this.entities.get(this.entities.size() - 1);
        }

        @Override
        public int getIndex(RailEntity root) {
            return this.entities.indexOf(root);
        }

        @Override
        public int size() {
            return this.entities.size();
        }

        @Override
        public boolean isSingular() {
            return false;
        }

        @Override
        public boolean isMultiple() {
            return true;
        }

        @Override
        protected boolean isActive() {
            for (RailEntity ent : this.entities) {
                if (!ent.isActive()) continue;
                return true;
            }
            return false;
        }

        @Override
        protected boolean getOrient(RailEntity ent) {
            Coupler coupler;
            RailEntity head = (RailEntity)this.entities.get(0);
            boolean rev = head.front.hasEntity();
            if (ent == head) {
                return rev ? !this.forward : this.forward;
            }
            Coupler coupler2 = coupler = rev ? head.rear : head.front;
            while (coupler.getOpposite().hasEntity()) {
                if ((coupler = coupler.getOpposite()).isFrontal() ? coupler.isFront() : coupler.isRear()) {
                    boolean bl = rev = !rev;
                }
                if ((coupler = coupler.getCounterpart()) != null && coupler.root != ent) continue;
            }
            return rev ? !this.forward : this.forward;
        }
    }

    public static class Singular
    extends Compound {
        public Singular(RailEntity root) {
            super(root.region.getSystem().getNewCompoundId());
            this.entities.add(root);
            root.com = this;
            COMPOUNDS.put(this.uid, this);
        }

        public Singular(RailRegion region, long uid, TagCW compound) {
            super(uid);
            RailEntity root = new RailEntity(region, this);
            root = root.read(compound);
            if (root == null) {
                return;
            }
            this.entities.add(root);
            COMPOUNDS.put(uid, this);
        }

        public Singular(RailEntity ent, long uid) {
            super(uid);
            this.entities.add(ent);
            COMPOUNDS.put(uid, this);
        }

        @Override
        public boolean isHead(RailEntity root) {
            return this.isThis(root);
        }

        @Override
        public boolean isEnd(RailEntity root) {
            return this.isThis(root);
        }

        @Override
        public RailEntity getHead() {
            return (RailEntity)this.entities.get(0);
        }

        @Override
        public RailEntity getEnd() {
            return (RailEntity)this.entities.get(0);
        }

        @Override
        public int getIndex(RailEntity root) {
            return this.isThis(root) ? 0 : -1;
        }

        private boolean isThis(RailEntity root) {
            return root.uid == ((RailEntity)this.entities.get((int)0)).uid;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean isSingular() {
            return true;
        }

        @Override
        public boolean isMultiple() {
            return false;
        }

        @Override
        protected boolean isActive() {
            return ((RailEntity)this.entities.get(0)).isActive();
        }

        @Override
        protected boolean getOrient(RailEntity ent) {
            return this.forward;
        }
    }
}

