/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.rail;

import java.util.concurrent.ConcurrentLinkedQueue;
import net.fexcraft.mod.fvtm.packet.Packets;
import net.fexcraft.mod.fvtm.sys.rail.Compound;
import net.fexcraft.mod.fvtm.sys.rail.RailEntity;
import net.fexcraft.mod.fvtm.sys.rail.RailSystem;
import net.fexcraft.mod.fvtm.sys.rail.Section;
import net.fexcraft.mod.fvtm.sys.rail.Track;
import net.fexcraft.mod.uni.tag.TagCW;

public class TrackUnit {
    private ConcurrentLinkedQueue<RailEntity> entities = new ConcurrentLinkedQueue();
    private RailSystem data;
    protected Track orig;
    protected Track copy;
    private Section section;
    private String uid;

    public TrackUnit(RailSystem data, String str, Long sid) {
        this.uid = str;
        this.data = data;
        this.section = this.data.getSection(sid);
        this.section.insert(this);
    }

    public void update(RailEntity ent, boolean add) {
        if (add) {
            this.entities.add(ent);
        } else {
            this.entities.remove(ent);
        }
    }

    public ConcurrentLinkedQueue<RailEntity> getEntities() {
        return this.entities;
    }

    public boolean hasCompound(Compound except) {
        if (except == null) {
            return this.entities.size() > 0;
        }
        for (RailEntity ent : this.entities) {
            if (ent.com.getUID() == except.getUID()) continue;
            return true;
        }
        return false;
    }

    public String getUID() {
        return this.uid;
    }

    public long getSectionId() {
        return this.section.getUID();
    }

    public Section section() {
        return this.section;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TrackUnit)) {
            return false;
        }
        return ((TrackUnit)o).uid.equals(this.uid);
    }

    public TrackUnit setSection(Section section, boolean update) {
        this.section = section;
        if (update) {
            this.updateClient();
        }
        return this;
    }

    public String toString() {
        return "TrackUnit[" + this.uid + "/" + (this.section == null ? "NULL" : Long.valueOf(this.section.getUID())) + "]";
    }

    private void updateClient() {
        if (this.data.isRemote()) {
            return;
        }
        TagCW compound = TagCW.create();
        compound.set("unit", this.getUID());
        compound.set("section", this.getSectionId());
        compound.set("dim", this.data.getWorldType().rec_key());
        if (this.orig == null && this.copy == null) {
            Packets.sendToAll(Packets.PKT_TAG, "rail_upd_unit_section", compound);
        } else {
            Track track = this.orig == null ? this.copy : this.orig;
            Packets.sendToAllTrackingPos(Packets.PKT_TAG, track.junction.root.getServerWorld(), track.start.vec, "rail_upd_unit_section", compound);
            if (track.length > 16.0) {
                Packets.sendToAllTrackingPos(Packets.PKT_TAG, track.junction.root.getServerWorld(), track.end.vec, "rail_upd_unit_section", compound);
            }
        }
    }
}

