/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.uni;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.mc.api.packet.IPacketReceiver;
import net.fexcraft.lib.mc.network.packet.PacketEntityUpdate;
import net.fexcraft.lib.mc.utils.ApiUtil;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.data.InteractZone;
import net.fexcraft.mod.fvtm.data.block.AABB;
import net.fexcraft.mod.fvtm.event.EventHandler;
import net.fexcraft.mod.fvtm.function.part.EngineFunction;
import net.fexcraft.mod.fvtm.sys.uni.Passenger;
import net.fexcraft.mod.fvtm.sys.uni.SeatInstance;
import net.fexcraft.mod.fvtm.sys.uni.VehicleInstance;
import net.fexcraft.mod.fvtm.util.CollisionUtil;
import net.fexcraft.mod.fvtm.util.OBB;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.impl.TagCWI;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.EntityWI;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RootVehicle
extends Entity
implements IEntityAdditionalSpawnData,
IPacketReceiver<PacketEntityUpdate>,
VehicleInstance.Holder {
    public VehicleInstance vehicle = new VehicleInstance((EntityW)new EntityWI((Entity)this), null);
    public float rotationRoll = 0.0f;
    public float prevRotationRoll = 0.0f;
    public boolean should_sit = true;

    public RootVehicle(World world) {
        super(world);
    }

    protected void init(TagCW com) {
        this.func_70105_a(this.vehicle.data.getAttribute("hitbox_width").asFloat(), this.vehicle.data.getAttribute("hitbox_height").asFloat());
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
        TagCW com = TagCW.wrap((Object)compound);
        this.field_70126_B = com.getFloat("RotationYaw");
        this.field_70127_C = com.getFloat("RotationPitch");
        this.prevRotationRoll = com.getFloat("RotationRoll");
        this.vehicle.init(null, com);
        this.init(com);
    }

    protected void func_70014_b(NBTTagCompound compound) {
        TagCW com = TagCW.wrap((Object)compound);
        this.vehicle.save(com);
    }

    public void writeSpawnData(ByteBuf buffer) {
        TagCW com = TagCW.create();
        this.writeSpawnData(com);
        this.vehicle.save(com);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)((NBTTagCompound)com.local()));
    }

    public void writeSpawnData(TagCW com) {
    }

    public void readSpawnData(TagCW com) {
    }

    public void readSpawnData(ByteBuf buffer) {
        try {
            TagCW com = TagCW.wrap((Object)ByteBufUtils.readTag((ByteBuf)buffer));
            this.vehicle.init(null, com);
            this.readSpawnData(com);
            this.init(com);
            this.field_70126_B = this.vehicle.point.getPivot().deg_yaw();
            this.field_70127_C = this.vehicle.point.getPivot().deg_pitch();
            this.prevRotationRoll = this.vehicle.point.getPivot().deg_roll();
        }
        catch (Exception e) {
            e.printStackTrace();
            FvtmLogger.log((Object)("Failed to receive additional spawn data for vehicle entity with ID " + this.func_145782_y() + "!"));
        }
    }

    public void func_70106_y() {
        if (this.vehicle != null) {
            this.vehicle.onRemove();
        }
        super.func_70106_y();
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posrotincr, boolean teleport) {
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return null;
    }

    public AxisAlignedBB func_174813_aQ() {
        return super.func_174813_aQ();
    }

    public boolean func_184222_aU() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public double func_70042_X() {
        return 0.0;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.NEUTRAL;
    }

    public double func_70033_W() {
        return 0.0;
    }

    public void func_70100_b_(EntityPlayer player) {
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_180430_e(float distance, float multiplier) {
    }

    public String func_70005_c_() {
        return this.vehicle.data.getName();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double dist) {
        return Config.RENDER_OUT_OF_VIEW ? true : super.func_70112_a(dist);
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_70114_g(this);
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (this.field_70128_L || hand == EnumHand.OFF_HAND) {
            return false;
        }
        int res = this.vehicle.onInteract(UniEntity.getEntity((Object)player), UniStack.getStack((Object)player.func_184614_ca()));
        return res >= 0;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70128_L) {
            return;
        }
        if (this.vehicle.data == null) {
            FvtmLogger.log((Object)("Vehicle '" + this.func_145782_y() + "' has no data, skipping update."));
            return;
        }
        if (this.field_70173_aa >= Integer.MAX_VALUE) {
            this.field_70173_aa = 0;
        }
        this.field_70126_B = this.vehicle.point.getPivot().deg_yaw();
        this.field_70127_C = this.vehicle.point.getPivot().deg_pitch();
        this.prevRotationRoll = this.vehicle.point.getPivot().deg_roll();
        this.vehicle.onUpdate();
        this.checkCollision();
    }

    private void checkCollision() {
        if (Config.DISABLE_OBB || this.vehicle.obb.isEmpty()) {
            return;
        }
        ArrayList checked = new ArrayList();
        for (InteractZone zone : this.vehicle.data.getInteractZones().values()) {
            float r = zone.range * 0.5f + 1.0f;
            Vec3d min = this.func_174791_d().func_72441_c(zone.pos.x - (double)r, zone.pos.y - (double)r, zone.pos.z - (double)r);
            Vec3d max = this.func_174791_d().func_72441_c(zone.pos.x + (double)r, zone.pos.y + (double)r, zone.pos.z + (double)r);
            this.field_70170_p.func_175647_a(Entity.class, new AxisAlignedBB(min, max), ent -> ent instanceof EntityLivingBase).forEach(ent -> {
                if (ent.func_184218_aH() || checked.contains(ent)) {
                    return;
                }
                OBB bb = new OBB().set(AABB.wrap(ent.func_174813_aQ()));
                for (OBB obb : this.vehicle.obb.values()) {
                    V3D res = CollisionUtil.check(bb, obb);
                    if (res == null) continue;
                    ent.func_70091_d(MoverType.SELF, -res.x * 0.5, res.y * 0.5, -res.z * 0.5);
                    checked.add(ent);
                }
            });
        }
    }

    public Entity func_184179_bs() {
        return null;
    }

    public void func_184232_k(Entity pass) {
        SeatInstance seat = this.vehicle.getSeatOf(pass);
        if (seat != null) {
            this.updatePassenger(pass, seat);
        } else {
            if (this.field_70170_p.field_72995_K) {
                ((Passenger)UniEntity.getApp((Object)pass, Passenger.class)).reqPassUpdate();
            }
            pass.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    public void updatePassenger(Entity pass, SeatInstance seat) {
        if (seat.passenger_direct() != pass) {
            seat.passenger(UniEntity.getEntity((Object)pass));
        }
        V3D pos = seat.getCurrentGlobalPosition();
        pass.func_70107_b(pos.x, pos.y - (pass instanceof EntityPlayer ? 0.7 : 0.0), pos.z);
        if (!this.field_70170_p.field_72995_K && pass instanceof EntityPlayerMP) {
            EventHandler.resetFlight((EntityPlayerMP)pass);
        }
    }

    public void func_184200_o(Entity pass) {
        super.func_184200_o(pass);
        SeatInstance seat = this.vehicle.getSeatOf(pass);
        if (seat != null) {
            seat.passenger(UniEntity.getEntity((Object)pass));
        }
    }

    public void func_184225_p(Entity pass) {
        for (SeatInstance seat : this.vehicle.seats) {
            if (!pass.equals(seat.passenger_direct())) continue;
            seat.passenger(null);
        }
        if (!this.field_70170_p.field_72995_K) {
            ((Passenger)UniEntity.getApp((Object)pass, Passenger.class)).set(-1, -1);
        }
        super.func_184225_p(pass);
    }

    public void func_184226_ay() {
        super.func_184226_ay();
    }

    protected boolean func_184219_q(Entity passenger) {
        return true;
    }

    public boolean shouldRiderSit() {
        return this.should_sit;
    }

    public void updateSittingState(Entity pass) {
        SeatInstance seat = this.vehicle.getSeatOf(pass);
        if (seat != null) {
            this.should_sit = seat.seat.sitting;
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return true;
        }
        if (source.field_76373_n.equals("player") && this.vehicle.driver() == null) {
            EngineFunction engine;
            EntityPlayer player = (EntityPlayer)source.func_76364_f();
            if (this.vehicle.data.getLock().isLocked()) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("interact.fvtm.vehicle.remove_locked", new Object[0]), true);
                return false;
            }
            EngineFunction engineFunction = engine = this.vehicle.data.hasPart("engine") ? (EngineFunction)this.vehicle.data.getFunctionInPart("engine", "fvtm:engine") : null;
            if (engine != null) {
                engine.setState(false);
            }
            if (this.vehicle.type.isRailVehicle()) {
                this.vehicle.railent.remove();
            } else {
                VehicleInstance trailer = this.vehicle;
                while ((trailer = trailer.rear) != null) {
                    Entity rear = (Entity)trailer.entity.local();
                    rear.func_70099_a((ItemStack)trailer.data.newItemStack().local(), 0.5f);
                    rear.func_70106_y();
                }
            }
            this.func_70099_a((ItemStack)this.vehicle.data.newItemStack().local(), 0.5f);
            this.func_70106_y();
            return true;
        }
        return true;
    }

    public ItemStack getPickedResult(RayTraceResult rtr) {
        return (ItemStack)this.vehicle.data.newItemStack().local();
    }

    public void processServerPacket(PacketEntityUpdate packet) {
        if (!packet.nbt.func_74764_b("task")) {
            return;
        }
        switch (packet.nbt.func_74779_i("task")) {
            case "resync": {
                NBTTagCompound nbt = (NBTTagCompound)this.vehicle.data.write(TagCW.create()).local();
                nbt.func_74778_a("task", "update_vehicledata");
                ApiUtil.sendEntityUpdatePacketToAllAround((Entity)this, (NBTTagCompound)nbt);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void processClientPacket(PacketEntityUpdate packet) {
        if (!packet.nbt.func_74764_b("task")) {
            return;
        }
        switch (packet.nbt.func_74779_i("task")) {
            case "resync": 
            case "update_vehicledata": {
                this.vehicle.data.read((TagCW)new TagCWI(packet.nbt));
                break;
            }
            case "toggle_lights": {
                this.vehicle.data.getAttribute("lights").set(packet.nbt.func_74767_n("lights"));
                this.vehicle.data.getAttribute("lights_long").set(packet.nbt.func_74767_n("lights_long"));
                VehicleInstance rear = this.vehicle.rear;
                while (rear != null) {
                    rear.data.getAttribute("lights").set(packet.nbt.func_74767_n("lights"));
                    rear.data.getAttribute("lights_long").set(packet.nbt.func_74767_n("lights_long"));
                    rear = rear.rear;
                }
                break;
            }
        }
    }

    public boolean isBraking() {
        return false;
    }

    @Override
    public VehicleInstance getVehicleInstance() {
        return this.vehicle;
    }

    @Override
    public void onPacket(EntityW pass, TagCW com) {
    }
}

