/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.ui.road;

import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.sys.road.UniRoadTool;
import net.fexcraft.mod.fvtm.ui.UIKeys;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.inv.UniInventory;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;

public class RoadToolCon
extends ContainerInterface {
    public static final String[] fills = new String[]{"RoadFill", "BottomFill", "SideLeftFill", "SideRightFill", "TopFill", "LinesFill", "SlabFill"};
    protected StackWrapper stack;
    protected boolean custom_road;
    protected boolean custom_slab;
    protected boolean custom_top;
    protected boolean custom_lines;
    protected int rt_width;
    protected boolean bot_on;
    protected boolean top_on;
    protected boolean lin_on;
    protected int rheight;
    protected int lheight;

    public RoadToolCon(JsonMap map, UniEntity player, V3I pos) {
        super(map, player, pos);
        this.stack = player.entity.getHeldItem(true);
        if (!this.stack.directTag().has(UniRoadTool.TAG_KEY)) {
            this.stack.updateTag(tag -> tag.set(UniRoadTool.TAG_KEY, TagCW.create()));
        }
        TagCW com = this.stack.directTag().getCompound(UniRoadTool.TAG_KEY);
        this.custom_road = com.has("CustomRoadFill");
        this.custom_slab = com.has("CustomSlabFill");
        this.custom_top = com.has("CustomTopFill");
        this.custom_lines = com.has("CustomLinesFill");
        this.rt_width = com.getInteger("Width");
        this.bot_on = com.getBoolean("Ground");
        this.top_on = com.getBoolean("Top");
        this.lin_on = com.getBoolean("Lines");
        this.rheight = com.getInteger("RHeight");
        this.lheight = com.getInteger("LHeight");
        this.inventory = UniInventory.create((int)fills.length).stacksize(1).name("Road Fill Inventory");
        for (int i = 0; i < fills.length; ++i) {
            if (!com.has(fills[i])) continue;
            this.inventory.set(i, com.getCompound(fills[i]));
        }
    }

    public Object get(String key, Object ... objs) {
        return null;
    }

    public void packet(TagCW com, boolean client) {
        switch (com.getString("cargo")) {
            case "add_width": {
                this.stack.updateTag(tag -> {
                    if (++this.rt_width > 64) {
                        this.rt_width = 64;
                    }
                    tag.getCompound(UniRoadTool.TAG_KEY).set("Width", this.rt_width);
                });
                break;
            }
            case "sub_width": {
                this.stack.updateTag(tag -> {
                    if (--this.rt_width < 1) {
                        this.rt_width = 1;
                    }
                    tag.getCompound(UniRoadTool.TAG_KEY).set("Width", this.rt_width);
                });
                break;
            }
            case "ground": {
                this.stack.updateTag(tag -> tag.getCompound(UniRoadTool.TAG_KEY).set("Ground", com.getBoolean("ground")));
                break;
            }
            case "add_left": {
                this.stack.updateTag(tag -> {
                    if (++this.lheight > 64) {
                        this.lheight = 64;
                    }
                    tag.getCompound(UniRoadTool.TAG_KEY).set("LHeight", this.lheight);
                });
                break;
            }
            case "sub_left": {
                this.stack.updateTag(tag -> {
                    if (--this.lheight < 0) {
                        this.lheight = 0;
                    }
                    tag.getCompound(UniRoadTool.TAG_KEY).set("LHeight", this.lheight);
                });
                break;
            }
            case "add_right": {
                this.stack.updateTag(tag -> {
                    if (++this.rheight > 64) {
                        this.rheight = 64;
                    }
                    tag.getCompound(UniRoadTool.TAG_KEY).set("RHeight", this.rheight);
                });
                break;
            }
            case "sub_right": {
                this.stack.updateTag(tag -> {
                    if (--this.rheight < 0) {
                        this.rheight = 0;
                    }
                    tag.getCompound(UniRoadTool.TAG_KEY).set("RHeight", this.rheight);
                });
                break;
            }
            case "top": {
                this.stack.updateTag(tag -> tag.getCompound(UniRoadTool.TAG_KEY).set("Top", com.getBoolean("top")));
                break;
            }
            case "lines": {
                this.stack.updateTag(tag -> tag.getCompound(UniRoadTool.TAG_KEY).set("Lines", com.getBoolean("lines")));
                break;
            }
            case "custom": {
                this.player.entity.openUI(UIKeys.ROAD_TOOL_CUSTOM, new V3I(com.getInteger("layer"), 0, 0));
                break;
            }
            case "remove": {
                this.stack.updateTag(tag -> tag.getCompound(UniRoadTool.TAG_KEY).rem("Custom" + fills[com.getInteger("layer")]));
                TagCW rtg = this.stack.directTag().getCompound(UniRoadTool.TAG_KEY);
                this.custom_road = rtg.has("CustomRoadFill");
                this.custom_slab = rtg.has("CustomSlabFill");
                this.custom_top = rtg.has("CustomTopFill");
                this.custom_lines = rtg.has("CustomLinesFill");
                if (client) break;
                SEND_TO_CLIENT.accept(rtg, this.player);
                break;
            }
        }
    }

    public void onClosed() {
        super.onClosed();
        if (this.player.entity.isOnClient()) {
            return;
        }
        this.stack.updateTag(ut -> {
            TagCW com = ut.getCompound(UniRoadTool.TAG_KEY);
            for (int i = 0; i < fills.length; ++i) {
                if (!this.inventory.empty(i)) {
                    TagCW tag = TagCW.create();
                    this.inventory.get(i).save(tag);
                    com.set(fills[i], tag);
                    continue;
                }
                com.rem(fills[i]);
            }
        });
    }
}

