/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.util;

import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.data.part.PartData;
import net.fexcraft.mod.fvtm.data.vehicle.SwivelPoint;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.render.EffectRenderer;
import net.fexcraft.mod.uni.Pos;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;

public class AnotherUtil {
    public static Vec3d toV3(Pos pos) {
        if (pos == null) {
            return new Vec3d(0.0, 0.0, 0.0);
        }
        return new Vec3d((double)pos.x16, (double)pos.y16, (double)pos.z16);
    }

    public static void translateAndRotatePartOnSwivelPoint(VehicleData vehicle, PartData data, float ticks) {
        SwivelPoint point = vehicle.getRotationPoint(data.getSwivelPointInstalledOn());
        V3D pos = data.getInstalledPos();
        V3D temp0 = point.getRelativeVector(pos);
        V3D temp1 = point.getPrevRelativeVector(pos);
        GL11.glRotated((double)-180.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)-180.0, (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)(temp1.x + (temp0.x - temp1.x) * (double)ticks), (double)(temp1.y + (temp0.y - temp1.y) * (double)ticks), (double)(temp1.z + (temp0.z - temp1.z) * (double)ticks));
        GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
        V3D rot = EffectRenderer.getRotations(point, ticks);
        GL11.glRotated((double)rot.z, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)rot.y, (double)0.0, (double)0.0, (double)1.0);
        GL11.glRotated((double)rot.x, (double)0.0, (double)1.0, (double)0.0);
        data.getInstalledRot().rotate112();
    }

    public static void translateAndRotatePartOnSwivelPointFast(VehicleData vehicle, PartData data) {
        SwivelPoint point = vehicle.getRotationPoint(data.getSwivelPointInstalledOn());
        V3D pos = point.getRelativeVector(data.getInstalledPos());
        GL11.glRotated((double)-180.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)-180.0, (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)pos.x, (double)pos.y, (double)pos.z);
        GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
        GL11.glRotatef((float)point.getPivot().deg_roll(), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)point.getPivot().deg_pitch(), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)point.getPivot().deg_yaw(), (float)0.0f, (float)1.0f, (float)0.0f);
        data.getInstalledRot().rotate112();
    }
}

