/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.util;

import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.data.block.AABB;
import net.fexcraft.mod.fvtm.data.vehicle.SwivelPoint;
import net.fexcraft.mod.fvtm.util.ContentConfigUtil;

public class OBB {
    public V3D[] axes = new V3D[3];
    public V3D[] verts = new V3D[8];

    public OBB() {
        int i;
        for (i = 0; i < this.axes.length; ++i) {
            this.axes[i] = new V3D();
        }
        for (i = 0; i < this.verts.length; ++i) {
            this.verts[i] = new V3D();
        }
    }

    public OBB set(AABB aabb) {
        this.verts[0].set(aabb.minX(), aabb.minY(), aabb.minZ());
        this.verts[1].set(aabb.minX(), aabb.minY(), aabb.maxZ());
        this.verts[2].set(aabb.minX(), aabb.maxY(), aabb.minZ());
        this.verts[3].set(aabb.minX(), aabb.maxY(), aabb.maxZ());
        this.verts[4].set(aabb.maxX(), aabb.minY(), aabb.minZ());
        this.verts[5].set(aabb.maxX(), aabb.minY(), aabb.maxZ());
        this.verts[6].set(aabb.maxX(), aabb.maxY(), aabb.minZ());
        this.verts[7].set(aabb.maxX(), aabb.maxY(), aabb.maxZ());
        this.genAxes();
        return this;
    }

    private void genAxes() {
        this.verts[0].sub(this.verts[1]).normalize(this.axes[0]);
        this.verts[0].sub(this.verts[2]).normalize(this.axes[1]);
        this.verts[0].sub(this.verts[4]).normalize(this.axes[2]);
    }

    public void update(SwivelPoint point, V3D pos, V3D veh, double x, double y, double z) {
        this.verts[0].set(-(x *= 0.5) + pos.x, -(y *= 0.5) + pos.y, -(z *= 0.5) + pos.z);
        this.verts[1].set(-x + pos.x, -y + pos.y, z + pos.z);
        this.verts[2].set(-x + pos.x, y + pos.y, -z + pos.z);
        this.verts[3].set(-x + pos.x, y + pos.y, z + pos.z);
        this.verts[4].set(x + pos.x, -y + pos.y, -z + pos.z);
        this.verts[5].set(x + pos.x, -y + pos.y, z + pos.z);
        this.verts[6].set(x + pos.x, y + pos.y, -z + pos.z);
        this.verts[7].set(x + pos.x, y + pos.y, z + pos.z);
        for (int i = 0; i < this.verts.length; ++i) {
            V3D rel = point.getRelativeVector(this.verts[i]);
            this.verts[i].x = rel.x + veh.x;
            this.verts[i].y = rel.y + veh.y;
            this.verts[i].z = rel.z + veh.z;
        }
        this.genAxes();
    }

    public V3D[] getCollisionAxes(OBB obb) {
        return new V3D[]{this.axes[0], this.axes[1], this.axes[2], obb.axes[0], obb.axes[1], obb.axes[2], this.axes[0].cross(obb.axes[0]).normalize(), this.axes[0].cross(obb.axes[1]).normalize(), this.axes[0].cross(obb.axes[2]).normalize(), this.axes[1].cross(obb.axes[0]).normalize(), this.axes[1].cross(obb.axes[1]).normalize(), this.axes[1].cross(obb.axes[2]).normalize(), this.axes[2].cross(obb.axes[0]).normalize(), this.axes[2].cross(obb.axes[1]).normalize(), this.axes[2].cross(obb.axes[2]).normalize()};
    }

    public static class OBBRef {
        public String point;
        public String key;
        public V3D pos;
        public V3D size;

        public OBBRef(String key, JsonMap map) {
            this.key = key;
            this.pos = ContentConfigUtil.getVector(map.getArray("pos"));
            this.size = map.has("size") ? ContentConfigUtil.getVector(map.getArray("size")) : new V3D(1.0, 1.0, 1.0);
            this.point = map.getString("point", "vehicle");
        }
    }
}

