/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.util;

import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.uni.tag.TagCW;

public class QV3D
implements Comparable<QV3D> {
    public final V3I pos;
    public final V3D vec;
    public final byte x;
    public final byte y;
    public final byte z;

    public QV3D() {
        this.pos = new V3I();
        this.vec = new V3D();
        this.z = 0;
        this.y = 0;
        this.x = 0;
    }

    public QV3D(double px, double py, double pz) {
        this.pos = new V3I((int)px, (int)py, (int)pz);
        byte bx = (byte)((px - (double)this.pos.x) / 0.0625);
        byte by = (byte)((py - (double)this.pos.y) / 0.0625);
        byte bz = (byte)((pz - (double)this.pos.z) / 0.0625);
        this.x = bx;
        this.y = by;
        this.z = bz;
        this.vec = this.toVec();
    }

    public QV3D(V3D pos) {
        this(pos.x, pos.y, pos.z);
    }

    public QV3D(V3I pos) {
        this((double)pos.x + 0.5, (double)pos.y + 0.5, (double)pos.z + 0.5);
    }

    public QV3D(QV3D other) {
        this.pos = other.pos.copy();
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
        this.vec = other.vec.copy();
    }

    public QV3D(TagCW com, String tag) {
        this.vec = com.getV3D(tag == null ? "vector" : tag);
        this.pos = new V3I(this.vec);
        this.x = (byte)((this.vec.x - (double)this.pos.x) / 0.0625);
        this.y = (byte)((this.vec.y - (double)this.pos.y) / 0.0625);
        this.z = (byte)((this.vec.z - (double)this.pos.z) / 0.0625);
    }

    private QV3D(int px, int py, int pz, byte xc, byte yc, byte zc) {
        this.pos = new V3I(px, py, pz);
        this.x = xc;
        this.y = yc;
        this.z = zc;
        this.vec = this.toVec();
    }

    public static QV3D exact(int px, int py, int pz, byte xc, byte yc, byte zc) {
        return new QV3D(px, py, pz, xc, yc, zc);
    }

    public TagCW write(TagCW com, String tag) {
        if (com == null) {
            com = TagCW.create();
        }
        com.set(tag == null ? "vector" : tag, this.vec);
        return com;
    }

    private V3D toVec() {
        return new V3D((double)this.pos.x + (double)this.x * 0.0625, (double)this.pos.y + (double)this.y * 0.0625, (double)this.pos.z + (double)this.z * 0.0625);
    }

    @Override
    public int compareTo(QV3D o) {
        if (o.pos.y > this.pos.y) {
            return 1;
        }
        if (o.pos.y < this.pos.y) {
            return -1;
        }
        if (o.pos.x > this.pos.x) {
            return 1;
        }
        if (o.pos.x < this.pos.x) {
            return -1;
        }
        if (o.pos.z > this.pos.z) {
            return 1;
        }
        if (o.pos.z < this.pos.z) {
            return -1;
        }
        if (o.y > this.y) {
            return 1;
        }
        if (o.y < this.y) {
            return -1;
        }
        if (o.x > this.x) {
            return 1;
        }
        if (o.x < this.x) {
            return -1;
        }
        if (o.z > this.z) {
            return 1;
        }
        if (o.z < this.z) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof V3D) {
            return obj.equals(this.vec);
        }
        if (!(obj instanceof QV3D)) {
            return false;
        }
        QV3D vec = (QV3D)obj;
        return vec.pos.equals((Object)this.pos) && this.x == vec.x && this.y == vec.y && this.z == vec.z;
    }

    public String toString() {
        return "(" + this.vec.x + ", " + this.vec.y + ", " + this.vec.z + ")";
    }

    public String asIDString() {
        return this.pos.x + "," + this.pos.y + "," + this.pos.z + "|" + this.x + "," + this.y + "," + this.z;
    }

    public static QV3D fromIDString(String str) {
        String[] arr0 = str.split("\\|");
        String[] arr1 = arr0[1].split(",");
        arr0 = arr0[0].split(",");
        int[] pxyz = new int[3];
        byte[] xyz = new byte[3];
        for (int i = 0; i < 3; ++i) {
            pxyz[i] = Integer.parseInt(arr0[i]);
            xyz[i] = Byte.parseByte(arr1[i]);
        }
        return new QV3D(pxyz[0], pxyz[1], pxyz[2], xyz[0], xyz[1], xyz[2]);
    }

    public QV3D copy() {
        return new QV3D(this);
    }
}

