/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.util.caps;

import net.fexcraft.lib.common.math.Time;
import net.fexcraft.lib.mc.utils.Print;
import net.fexcraft.lib.mc.utils.Static;
import net.fexcraft.mod.fvtm.FVTM;
import net.fexcraft.mod.fvtm.data.Capabilities;
import net.fexcraft.mod.fvtm.data.container.ContainerData;
import net.fexcraft.mod.fvtm.data.container.ContainerHolder;
import net.fexcraft.mod.fvtm.data.container.ContainerSlot;
import net.fexcraft.mod.fvtm.data.container.ContainerType;
import net.fexcraft.mod.fvtm.ui.UIKeys;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class ContainerHolderUtil
implements ICapabilitySerializable<NBTBase> {
    public static final String REGNAM = "fvtm:containerholder";
    private Implementation instance;

    public ContainerHolderUtil(Entity entity) {
        this.instance = new Implementation().setEntity(entity);
        if (this.instance.getWrapper() != null) {
            this.instance.getWrapper().setupCapability(this.instance);
            this.instance.setup = true;
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability != null && capability == Capabilities.CONTAINER;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability != null && capability == Capabilities.CONTAINER ? Capabilities.CONTAINER.cast((Object)this.instance) : null);
    }

    public NBTBase serializeNBT() {
        return Capabilities.CONTAINER.getStorage().writeNBT(Capabilities.CONTAINER, (Object)this.instance, null);
    }

    public void deserializeNBT(NBTBase nbt) {
        Capabilities.CONTAINER.getStorage().readNBT(Capabilities.CONTAINER, (Object)this.instance, null, nbt);
    }

    public static class Implementation
    implements ContainerHolder {
        private Entity entity;
        private ContainerHolder.ContainerHolderWrapper conhol;
        private ContainerSlot[] slots = new ContainerSlot[0];
        private String[] ids = new String[0];
        public boolean setup;

        public NBTTagCompound write(EnumFacing side) {
            NBTTagCompound compound = new NBTTagCompound();
            for (int i = 0; i < this.slots.length; ++i) {
                compound.func_74782_a("Slot" + i, (NBTBase)this.slots[i].write(null));
            }
            compound.func_74768_a("Slots", this.slots.length);
            return compound;
        }

        public void read(EnumFacing side, NBTTagCompound compound) {
            int i;
            this.slots = new ContainerSlot[compound.func_74762_e("Slots")];
            for (i = 0; i < this.slots.length; ++i) {
                if (!compound.func_74764_b("Slot" + i)) continue;
                this.slots[i] = new ContainerSlot().read(compound.func_74775_l("Slot" + i));
            }
            this.ids = new String[this.slots.length];
            for (i = 0; i < this.slots.length; ++i) {
                this.ids[i] = this.slots[i].id;
            }
        }

        public Implementation setEntity(Entity ent) {
            this.entity = ent;
            if (this.entity instanceof ContainerHolder.ContainerHolderWrapper) {
                this.conhol = (ContainerHolder.ContainerHolderWrapper)ent;
            }
            return this;
        }

        @Override
        public ContainerSlot[] getContainerSlots() {
            return this.slots;
        }

        @Override
        public ContainerSlot getContainerSlot(String id) {
            for (ContainerSlot slot : this.slots) {
                if (!slot.id.equals(id)) continue;
                return slot;
            }
            return null;
        }

        @Override
        public String[] getContainerSlotIds() {
            return this.ids;
        }

        @Override
        public void addContainerSlot(ContainerSlot slot) {
            if (this.setup) {
                Print.log((Object)(this.entity.func_70005_c_() + " --> Tried to register a new Container Slot, but setup is already over."));
                return;
            }
            if (this.contains(slot.id)) {
                ContainerSlot con = this.getContainerSlot(slot.id);
                con.position = slot.position;
                con.rotation = slot.rotation;
                return;
            }
            ContainerSlot[] arr = new ContainerSlot[this.slots.length + 1];
            String[] idz = new String[this.slots.length + 1];
            for (int i = 0; i < this.slots.length; ++i) {
                arr[i] = this.slots[i];
                idz[i] = this.slots[i].id;
            }
            arr[this.slots.length] = slot;
            idz[this.slots.length] = slot.id;
            this.slots = arr;
            this.ids = idz;
            this.sync(false);
        }

        private boolean contains(String id) {
            for (String str : this.ids) {
                if (!str.equals(id)) continue;
                return true;
            }
            return false;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void render(double x, double y, double z, double yaw, double pitch, double roll) {
            GL11.glPushMatrix();
            if (x != 0.0 || y != 0.0 || z != 0.0) {
                GL11.glTranslated((double)x, (double)y, (double)z);
            }
            for (ContainerSlot slot : this.slots) {
                slot.render(this.entity, yaw, pitch, roll);
            }
            GL11.glPopMatrix();
        }

        @SideOnly(value=Side.CLIENT)
        public void renderDebug(double x, double y, double z, double yaw, double pitch, double roll) {
            GL11.glPushMatrix();
            if (x != 0.0 || y != 0.0 || z != 0.0) {
                GL11.glTranslated((double)x, (double)y, (double)z);
            }
            for (ContainerSlot slot : this.slots) {
                slot.renderDebug(this.entity, yaw, pitch, roll, ContainerType.values()[Time.getSecond() % 10 / 2]);
            }
            GL11.glPopMatrix();
        }

        @Override
        public void sync(boolean fromside) {
        }

        @Override
        public void openGUI(EntityPlayer player) {
            if (player == null) {
                Static.exception((Exception)new Exception("Tried to open GUI on server side, but no player specified / is NULL."), (boolean)false);
            }
            player.openGui((Object)FVTM.getInstance(), UIKeys.VEHICLE_CONTAINERS.id, this.entity.field_70170_p, 0, this.entity.func_145782_y(), 0);
        }

        @Override
        public void dropContents() {
            if (this.entity.field_70170_p.field_72995_K) {
                return;
            }
            for (ContainerSlot slot : this.slots) {
                for (ContainerData data : slot.getContainers()) {
                    if (data == null) continue;
                    EntityItem stack = new EntityItem(this.entity.field_70170_p);
                    stack.func_92058_a((ItemStack)data.getNewStack().local());
                    stack.func_70107_b(this.entity.field_70165_t, this.entity.field_70163_u + 1.0, this.entity.field_70161_v);
                    this.entity.field_70170_p.func_72838_d((Entity)stack);
                }
                slot.clear();
            }
        }

        @Override
        public ContainerHolder setWrapper(ContainerHolder.ContainerHolderWrapper wrapper) {
            this.conhol = wrapper;
            return this;
        }

        @Override
        public ContainerHolder.ContainerHolderWrapper getWrapper() {
            return this.conhol;
        }
    }

    public static class Callable
    implements java.util.concurrent.Callable<ContainerHolder> {
        @Override
        public ContainerHolder call() throws Exception {
            return new Implementation();
        }
    }

    public static class Storage
    implements Capability.IStorage<ContainerHolder> {
        public NBTBase writeNBT(Capability<ContainerHolder> capability, ContainerHolder instance, EnumFacing side) {
            return ((Implementation)instance).write(side);
        }

        public void readNBT(Capability<ContainerHolder> capability, ContainerHolder instance, EnumFacing side, NBTBase nbt) {
            try {
                Implementation impl = (Implementation)instance;
                impl.read(side, (NBTTagCompound)nbt);
                impl.sync(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

