/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.util.caps;

import java.util.ArrayList;
import java.util.HashMap;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.data.Capabilities;
import net.fexcraft.mod.fvtm.data.block.MultiBlock;
import net.fexcraft.mod.fvtm.data.block.MultiBlockCache;
import net.fexcraft.mod.fvtm.data.block.MultiBlockData;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class MultiBlockCacheSerializer
implements ICapabilitySerializable<NBTBase> {
    private MultiBlockCache instance = (MultiBlockCache)Capabilities.MULTIBLOCKS.getDefaultInstance();

    public MultiBlockCacheSerializer(World world) {
        this.instance.setWorld(world);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability != null && capability == Capabilities.MULTIBLOCKS;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability != null && capability == Capabilities.MULTIBLOCKS ? Capabilities.MULTIBLOCKS.cast((Object)this.instance) : null);
    }

    public NBTBase serializeNBT() {
        return Capabilities.MULTIBLOCKS.getStorage().writeNBT(Capabilities.MULTIBLOCKS, (Object)this.instance, null);
    }

    public void deserializeNBT(NBTBase nbt) {
        Capabilities.MULTIBLOCKS.getStorage().readNBT(Capabilities.MULTIBLOCKS, (Object)this.instance, null, nbt);
    }

    public static class Implementation
    implements MultiBlockCache {
        private World world;
        private HashMap<BlockPos, MultiBlockData> blocks = new HashMap();
        private HashMap<BlockPos, BlockPos> cores = new HashMap();

        @Override
        public void setWorld(World world) {
            this.world = world;
        }

        @Override
        public void registerMultiBlock(BlockPos posfrom, EnumFacing rotation, MultiBlockData data) {
            ArrayList<V3I> positions = ((MultiBlock)data.getType()).getPositions(new V3I(posfrom.func_177958_n(), posfrom.func_177956_o(), posfrom.func_177952_p()), WrapperHolder.getSide((Object)rotation));
            for (V3I vec : positions) {
                BlockPos pos = new BlockPos(vec.x, vec.y, vec.z);
                this.blocks.put(pos, data);
                this.cores.put(pos, posfrom);
            }
        }

        @Override
        public void unregisterMultiBlock(BlockPos posfrom, EnumFacing rotation, MultiBlockData data) {
            ArrayList<V3I> positions = ((MultiBlock)data.getType()).getPositions(new V3I(posfrom.func_177958_n(), posfrom.func_177956_o(), posfrom.func_177952_p()), WrapperHolder.getSide((Object)rotation));
            for (V3I vec : positions) {
                BlockPos pos = new BlockPos(vec.x, vec.y, vec.z);
                this.blocks.remove(pos, data);
                this.cores.remove(pos, posfrom);
            }
        }

        @Override
        public MultiBlockData getMultiBlock(BlockPos pos) {
            return this.blocks.get(pos);
        }

        @Override
        public BlockPos getMultiBlockCore(BlockPos pos) {
            return this.cores.get(pos);
        }
    }

    public static class Callable
    implements java.util.concurrent.Callable<MultiBlockCache> {
        @Override
        public MultiBlockCache call() throws Exception {
            return new Implementation();
        }
    }

    public static class Storage
    implements Capability.IStorage<MultiBlockCache> {
        public NBTBase writeNBT(Capability<MultiBlockCache> capability, MultiBlockCache instance, EnumFacing side) {
            return new NBTTagByte(0);
        }

        public void readNBT(Capability<MultiBlockCache> capability, MultiBlockCache instance, EnumFacing side, NBTBase nbt) {
        }
    }
}

