/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.util.handler;

import net.fexcraft.mod.fvtm.handler.InteractionHandler;
import net.fexcraft.mod.fvtm.sys.uni.KeyPress;
import net.fexcraft.mod.fvtm.sys.uni.Passenger;
import net.fexcraft.mod.fvtm.sys.uni.RootVehicle;
import net.fexcraft.mod.fvtm.sys.uni.SeatInstance;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.world.EntityW;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class KeyHandler {
    private static Minecraft minecraft;
    public static KeyBinding engineToggle;
    public static KeyBinding openInventory;
    public static KeyBinding control;
    public static KeyBinding scriptsGUI;
    public static KeyBinding lightsToggle;
    public static KeyBinding trailerToggle;
    public static KeyBinding wagonToggle;
    public static KeyBinding reset;
    public static KeyBinding brake;
    public static KeyBinding pbrake;
    public static KeyBinding arrow_up;
    public static KeyBinding arrow_down;
    public static KeyBinding arrow_left;
    public static KeyBinding arrow_right;
    public static final String category = "keycompound.fvtm.controls";
    private static boolean toggables;

    public KeyHandler() {
        minecraft = Minecraft.func_71410_x();
        engineToggle = new KeyBinding("key.fvtm.engine", (IKeyConflictContext)KeyConflictContext.VEHICLE, 29, category);
        ClientRegistry.registerKeyBinding((KeyBinding)engineToggle);
        openInventory = new KeyBinding("key.fvtm.vehicle_inventory", (IKeyConflictContext)KeyConflictContext.VEHICLE, 19, category);
        ClientRegistry.registerKeyBinding((KeyBinding)openInventory);
        control = new KeyBinding("key.fvtm.vehicle_control", (IKeyConflictContext)KeyConflictContext.VEHICLE, 37, category);
        ClientRegistry.registerKeyBinding((KeyBinding)control);
        scriptsGUI = new KeyBinding("key.fvtm.vehicle_scripts", (IKeyConflictContext)KeyConflictContext.VEHICLE, 34, category);
        ClientRegistry.registerKeyBinding((KeyBinding)scriptsGUI);
        lightsToggle = new KeyBinding("key.fvtm.vehicle_lights", (IKeyConflictContext)KeyConflictContext.VEHICLE, 38, category);
        ClientRegistry.registerKeyBinding((KeyBinding)lightsToggle);
        trailerToggle = new KeyBinding("key.fvtm.vehicle_trailer", (IKeyConflictContext)KeyConflictContext.VEHICLE, 11, category);
        ClientRegistry.registerKeyBinding((KeyBinding)trailerToggle);
        wagonToggle = new KeyBinding("key.fvtm.vehicle_wagon", (IKeyConflictContext)KeyConflictContext.VEHICLE, 12, category);
        ClientRegistry.registerKeyBinding((KeyBinding)wagonToggle);
        arrow_up = new KeyBinding("key.fvtm.arrow_up", (IKeyConflictContext)KeyConflictContext.VEHICLE, 200, category);
        ClientRegistry.registerKeyBinding((KeyBinding)arrow_up);
        arrow_down = new KeyBinding("key.fvtm.arrow_down", (IKeyConflictContext)KeyConflictContext.VEHICLE, 208, category);
        ClientRegistry.registerKeyBinding((KeyBinding)arrow_down);
        arrow_left = new KeyBinding("key.fvtm.arrow_left", (IKeyConflictContext)KeyConflictContext.VEHICLE, 203, category);
        ClientRegistry.registerKeyBinding((KeyBinding)arrow_left);
        arrow_right = new KeyBinding("key.fvtm.arrow_right", (IKeyConflictContext)KeyConflictContext.VEHICLE, 205, category);
        ClientRegistry.registerKeyBinding((KeyBinding)arrow_right);
        reset = new KeyBinding("key.fvtm.reset", (IKeyConflictContext)KeyConflictContext.TOGGABLE, 39, category);
        ClientRegistry.registerKeyBinding((KeyBinding)reset);
        brake = new KeyBinding("key.fvtm.brake", (IKeyConflictContext)KeyConflictContext.VEHICLE, 57, category);
        ClientRegistry.registerKeyBinding((KeyBinding)brake);
        pbrake = new KeyBinding("key.fvtm.pbrake", (IKeyConflictContext)KeyConflictContext.VEHICLE, 24, category);
        ClientRegistry.registerKeyBinding((KeyBinding)pbrake);
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (KeyHandler.minecraft.field_71439_g == null || KeyHandler.minecraft.field_71441_e == null) {
            return;
        }
        switch (event.phase) {
            case START: {
                if (!(KeyHandler.minecraft.field_71439_g.func_184187_bx() instanceof RootVehicle) || KeyHandler.minecraft.field_71462_r != null) break;
                this.handleKeyboardInput();
            }
        }
    }

    public void handleKeyboardInput() {
        Passenger pass = (Passenger)UniEntity.getApp((Object)KeyHandler.minecraft.field_71439_g, Passenger.class);
        EntityW player = pass.entity;
        SeatInstance seat = pass.getSeatOn();
        if (seat == null) {
            return;
        }
        boolean state = this.isKeyDown(KeyHandler.minecraft.field_71474_y.field_74351_w.func_151463_i());
        if (state != seat.root.getKeyPressState(KeyPress.ACCELERATE)) {
            seat.onKeyPress(KeyPress.ACCELERATE, player, state);
        }
        if ((state = this.isKeyDown(KeyHandler.minecraft.field_71474_y.field_74368_y.func_151463_i())) != seat.root.getKeyPressState(KeyPress.DECELERATE)) {
            seat.onKeyPress(KeyPress.DECELERATE, player, state);
        }
        if (this.isKeyDown(KeyHandler.minecraft.field_71474_y.field_74370_x.func_151463_i())) {
            seat.onKeyPress(KeyPress.TURN_LEFT, player);
        }
        if (this.isKeyDown(KeyHandler.minecraft.field_71474_y.field_74366_z.func_151463_i())) {
            seat.onKeyPress(KeyPress.TURN_RIGHT, player);
        }
        if (this.isKeyDown(arrow_up.func_151463_i())) {
            seat.onKeyPress(seat.root.type.isAirVehicle() ? KeyPress.ACCELERATE : KeyPress.GEAR_UP, player);
        }
        if (this.isKeyDown(arrow_down.func_151463_i())) {
            seat.onKeyPress(seat.root.type.isAirVehicle() ? KeyPress.DECELERATE : KeyPress.GEAR_DOWN, player);
        }
        if (this.isKeyDown(arrow_left.func_151463_i())) {
            seat.onKeyPress(KeyPress.ROLL_LEFT, player);
        }
        if (this.isKeyDown(arrow_right.func_151463_i())) {
            seat.onKeyPress(KeyPress.ROLL_RIGHT, player);
        }
        if (this.isKeyDown(pbrake.func_151463_i())) {
            seat.onKeyPress(KeyPress.PBRAKE, player);
        }
        if ((state = this.isKeyDown(brake.func_151463_i())) != seat.root.getKeyPressState(KeyPress.BRAKE)) {
            seat.onKeyPress(KeyPress.BRAKE, player, state);
        }
        if (this.isKeyDown(engineToggle.func_151463_i())) {
            seat.onKeyPress(KeyPress.ENGINE, player);
        }
        if (this.isKeyDown(KeyHandler.minecraft.field_71474_y.field_74311_E.func_151463_i())) {
            seat.onKeyPress(KeyPress.DISMOUNT, player);
        }
        if (this.isKeyDown(openInventory.func_151463_i())) {
            seat.onKeyPress(KeyPress.INVENTORY, player);
        }
        if (this.isKeyDown(control.func_151463_i())) {
            seat.onKeyPress(KeyPress.CONTROL, player);
        }
        if (this.isKeyDown(scriptsGUI.func_151463_i())) {
            seat.onKeyPress(KeyPress.SCRIPTS, player);
        }
        if (this.isKeyDown(lightsToggle.func_151463_i())) {
            seat.onKeyPress(KeyPress.LIGHTS, player);
        }
        if (this.isKeyDown(trailerToggle.func_151463_i())) {
            seat.onKeyPress(KeyPress.COUPLER_REAR, player);
        }
        if (this.isKeyDown(wagonToggle.func_151463_i())) {
            seat.onKeyPress(KeyPress.COUPLER_FRONT, player);
        }
        if (this.isKeyDown(reset.func_151463_i())) {
            seat.onKeyPress(KeyPress.RESET, player);
        }
    }

    public boolean isKeyDown(int keycode) {
        return keycode < 0 ? Mouse.isButtonDown((int)(keycode + 100)) : keycode <= 255 && Keyboard.isKeyDown((int)keycode);
    }

    @SubscribeEvent
    public void clickEmpty(PlayerInteractEvent.RightClickEmpty event) {
        if (event.getHand() == EnumHand.MAIN_HAND) {
            InteractionHandler.handle(KeyPress.MOUSE_RIGHT, UniStack.getStack((Object)event.getItemStack()));
        }
    }

    @SubscribeEvent
    public void clickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        if (event.getHand() == EnumHand.MAIN_HAND) {
            InteractionHandler.handle(KeyPress.MOUSE_MAIN, UniStack.getStack((Object)event.getItemStack()));
        }
    }

    @SubscribeEvent
    public void clickItem(PlayerInteractEvent.RightClickItem event) {
        if (!event.getWorld().field_72995_K) {
            return;
        }
        if (event.getHand() == EnumHand.MAIN_HAND && InteractionHandler.handle(KeyPress.MOUSE_RIGHT, UniStack.getStack((Object)event.getItemStack()))) {
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.PASS);
        }
    }

    @SubscribeEvent
    public void clickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getWorld().field_72995_K) {
            return;
        }
        if (event.getHand() == EnumHand.MAIN_HAND && InteractionHandler.handle(KeyPress.MOUSE_RIGHT, UniStack.getStack((Object)event.getItemStack()))) {
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.PASS);
        }
    }

    @SubscribeEvent
    public void clickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (!event.getWorld().field_72995_K) {
            return;
        }
        if (event.getHand() == EnumHand.MAIN_HAND && InteractionHandler.handle(KeyPress.MOUSE_MAIN, UniStack.getStack((Object)event.getItemStack()))) {
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.PASS);
        }
    }

    public static enum KeyConflictContext implements IKeyConflictContext
    {
        VEHICLE{

            public boolean isActive() {
                return minecraft.field_71439_g != null && minecraft.field_71439_g.func_184187_bx() instanceof RootVehicle;
            }

            public boolean conflicts(IKeyConflictContext other) {
                return other == this;
            }
        }
        ,
        TOGGABLE{

            public boolean isActive() {
                return InteractionHandler.handle(KeyPress.RESET, StackWrapper.EMPTY);
            }

            public boolean conflicts(IKeyConflictContext other) {
                return other == this;
            }
        };

    }
}

