/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.uni.impl;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.block.Asphalt;
import net.fexcraft.mod.fvtm.block.generated.FvtmProperties;
import net.fexcraft.mod.fvtm.block.generated.G_ROAD;
import net.fexcraft.mod.fvtm.data.InteractZone;
import net.fexcraft.mod.fvtm.data.block.JackEntity;
import net.fexcraft.mod.fvtm.data.vehicle.SwivelPoint;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.entity.BlockSeat;
import net.fexcraft.mod.fvtm.handler.InteractionHandler;
import net.fexcraft.mod.fvtm.sys.pro.LandVehicle;
import net.fexcraft.mod.fvtm.sys.pro.RailVehicle;
import net.fexcraft.mod.fvtm.sys.pro.WheelEntity;
import net.fexcraft.mod.fvtm.sys.rail.RailEntity;
import net.fexcraft.mod.fvtm.sys.uni.FvtmWorld;
import net.fexcraft.mod.fvtm.sys.uni.Passenger;
import net.fexcraft.mod.fvtm.sys.uni.RootVehicle;
import net.fexcraft.mod.fvtm.sys.uni.SeatInstance;
import net.fexcraft.mod.fvtm.sys.uni.UniWheel;
import net.fexcraft.mod.fvtm.sys.uni.VehicleInstance;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.packet.PacketTagListener;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.StateWrapper;
import net.fexcraft.mod.uni.world.WorldWI;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class WorldWIE
extends WorldWI
implements FvtmWorld {
    public WorldWIE(World level) {
        super(level);
    }

    public void spawnBlockSeat(V3D vec, EntityW player) {
        BlockSeat seat = new BlockSeat(this.world);
        seat.func_70107_b(vec.x, vec.y, vec.z);
        this.world.func_72838_d((Entity)seat);
        ((Entity)player.direct()).func_184220_m((Entity)seat);
    }

    @Override
    public SeatInstance getSeat(int entid, int seatid) {
        Entity ent = this.world.func_73045_a(entid);
        if (ent == null) {
            return null;
        }
        return ((RootVehicle)ent).vehicle.seats.get(seatid);
    }

    @Override
    public SwivelPoint getSwivelPoint(int entid, String pointid) {
        Entity ent = this.world.func_73045_a(entid);
        if (ent == null) {
            return null;
        }
        return ((RootVehicle)ent).vehicle.data.getRotationPoint(pointid);
    }

    @Override
    public Passenger getPassenger(int id) {
        Entity ent = this.world.func_73045_a(id);
        if (ent == null) {
            return null;
        }
        return (Passenger)UniEntity.getApp((Object)ent, Passenger.class);
    }

    @Override
    public VehicleInstance getVehicle(int entid) {
        Entity ent = this.world.func_73045_a(entid);
        if (!(ent instanceof RootVehicle)) {
            return null;
        }
        return ((RootVehicle)ent).vehicle;
    }

    @Override
    public Map.Entry<VehicleData, InteractionHandler.InteractRef> getInteractRef(TagCW packet) {
        if (packet.has("entity")) {
            VehicleInstance inst = this.getVehicle(packet.getInteger("entity"));
            return inst == null ? null : new AbstractMap.SimpleEntry<VehicleData, InteractionHandler.InteractRef>(inst.data, inst.iref());
        }
        V3I pos = new V3I(packet.getIntArray("lift"), 0);
        JackEntity tile = (JackEntity)this.world.func_175625_s(new BlockPos(pos.x, pos.y, pos.z));
        return tile == null ? null : new AbstractMap.SimpleEntry<VehicleData, InteractionHandler.InteractRef>(tile.getVehicle(), tile.iref());
    }

    @Override
    public boolean noViewEntity() {
        return Minecraft.func_71410_x().func_175606_aa() == null || Minecraft.func_71410_x().func_175606_aa().field_70170_p == null;
    }

    @Override
    public ArrayList<VehicleInstance> getVehicles(V3D pos) {
        ArrayList<VehicleInstance> list = new ArrayList<VehicleInstance>();
        VehicleInstance inst = null;
        block0: for (Entity entity : this.world.field_72996_f) {
            if (!(entity instanceof RootVehicle)) continue;
            inst = ((RootVehicle)entity).vehicle;
            for (InteractZone zone : inst.data.getInteractZones().values()) {
                if (list.contains(inst)) continue block0;
                if (!zone.inRange(inst, pos)) continue;
                list.add(inst);
            }
        }
        return list;
    }

    @Override
    public Map<VehicleData, InteractionHandler.InteractRef> getVehicleDatas(V3D pos) {
        LinkedHashMap<VehicleData, InteractionHandler.InteractRef> map = new LinkedHashMap<VehicleData, InteractionHandler.InteractRef>();
        VehicleInstance inst = null;
        block0: for (Entity entity : this.world.field_72996_f) {
            if (!(entity instanceof RootVehicle)) continue;
            inst = ((RootVehicle)entity).vehicle;
            for (InteractZone zone : inst.data.getInteractZones().values()) {
                if (map.containsKey(inst.data)) continue block0;
                if (!zone.inRange(inst, pos)) continue;
                map.put(inst.data, new InteractionHandler.InteractRef(inst));
            }
        }
        block2: for (TileEntity tile : this.world.field_147482_g) {
            JackEntity jack;
            if (!(tile instanceof JackEntity) || (jack = (JackEntity)tile).getVehicle() == null) continue;
            for (InteractZone zone : jack.getVehicle().getInteractZones().values()) {
                if (map.containsKey(jack.getVehicle())) continue block2;
                if (!zone.inRange(jack.getVehicle(), jack.getVehiclePos(), pos)) continue;
                map.put(jack.getVehicle(), jack.iref());
            }
        }
        return map;
    }

    @Override
    public Passenger getClientPassenger() {
        return (Passenger)UniEntity.getApp((Object)Minecraft.func_71410_x().field_71439_g, Passenger.class);
    }

    @Override
    public boolean isFvtmRoad(StateWrapper state) {
        return state.getBlock() == Asphalt.INSTANCE || state.getBlock() instanceof G_ROAD;
    }

    @Override
    public int getRoadHeight(StateWrapper state) {
        return this.isFvtmRoad(state) ? ((Integer)((IBlockState)state.direct()).func_177229_b((IProperty)FvtmProperties.HEIGHT)).intValue() : ((IBlockState)state.direct()).func_177230_c().func_176201_c((IBlockState)state.local());
    }

    @Override
    public StateWrapper getRoadWithHeight(StateWrapper block, int height) {
        return StateWrapper.of((Object)((IBlockState)block.direct()).func_177230_c().func_176203_a(height));
    }

    @Override
    public void handleBlockEntityPacket(TagCW com, EntityW player) {
        BlockPos pos = BlockPos.func_177969_a((long)com.getLong("pos"));
        TileEntity tile = this.world.func_175625_s(pos);
        if (tile instanceof PacketTagListener) {
            ((PacketTagListener)tile).handle(com, player);
        } else {
            FvtmLogger.debug((Object)("No receiver for packet '" + com + "' found. Dest: " + pos));
        }
    }

    @Override
    public void spawnRailEntity(RailEntity ent) {
        this.world.func_72838_d((Entity)new RailVehicle(this.world, ent));
    }

    @Override
    public void spawnLandEntity(VehicleData data, V3D pos, EntityW placer) {
        this.world.func_72838_d((Entity)new LandVehicle(this.world, data, new Vec3d(pos.x, pos.y + 2.0, pos.z), placer == null ? null : (EntityPlayer)placer.local(), -1));
    }

    @Override
    public void spawnLandEntity(VehicleData data, VehicleInstance truck, EntityW placer) {
        this.world.func_72838_d((Entity)new LandVehicle((LandVehicle)truck.entity.local(), data, (EntityPlayer)placer.local()));
    }

    @Override
    public UniWheel spawnWheel(VehicleInstance vehicle, String id) {
        WheelEntity wheel = new WheelEntity((RootVehicle)vehicle.entity.local(), id);
        this.world.func_72838_d((Entity)wheel);
        return wheel;
    }
}

