/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic.client.gui.widget;

import java.util.function.Consumer;
import net.minecraft.class_10799;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import net.minecraft.class_8015;
import net.minecraft.class_8494;
import net.minecraft.class_9848;

public class SliderWidget
extends class_339 {
    private static final class_2960 SLIDER_SPRITE = class_2960.method_60656((String)"widget/slider");
    private static final class_2960 HIGHLIGHTED_SPRITE = class_2960.method_60656((String)"widget/slider_highlighted");
    private static final class_2960 SLIDER_HANDLE_SPRITE = class_2960.method_60656((String)"widget/slider_handle");
    private static final class_2960 SLIDER_HANDLE_HIGHLIGHTED_SPRITE = class_2960.method_60656((String)"widget/slider_handle_highlighted");
    private final double min;
    private final double max;
    private final double step;
    private final String name;
    private final Consumer<Double> action;
    protected double delta;
    protected double value;
    private boolean canChangeValue;
    protected boolean displayInt;

    public SliderWidget(double min, double max, double step, String suffix, Consumer<Double> action, double value, boolean displayInt, double base) {
        super(0, 0, 0, 0, class_5244.field_39003);
        this.min = min;
        this.max = max;
        this.step = 1.0 / step;
        this.name = "config.tectonic." + suffix;
        this.action = action;
        this.value = value;
        this.delta = this.valueToDelta();
        this.displayInt = displayInt;
        class_5250 text = class_2561.method_43473();
        text.method_10852((class_2561)class_2561.method_43471((String)(this.name + ".tooltip")));
        text.method_10852(class_5244.field_33849);
        text.method_10852((class_2561)class_2561.method_43471((String)"config.tectonic.default"));
        if (this.displayInt) {
            text.method_27693("\u00a7e" + (int)base);
        } else {
            text.method_27693("\u00a7e" + base);
        }
        this.method_47400(class_7919.method_47407((class_2561)text));
        this.updateMessage();
    }

    private class_2960 getSprite() {
        return this.method_25370() && !this.canChangeValue ? HIGHLIGHTED_SPRITE : SLIDER_SPRITE;
    }

    private class_2960 getHandleSprite() {
        return !this.field_22762 && !this.canChangeValue ? SLIDER_HANDLE_SPRITE : SLIDER_HANDLE_HIGHLIGHTED_SPRITE;
    }

    protected class_5250 method_25360() {
        return class_2561.method_43469((String)"gui.narrate.slider", (Object[])new Object[]{this.method_25369()});
    }

    public void method_47399(class_6382 narrationElementOutput) {
        narrationElementOutput.method_37034(class_6381.field_33788, (class_2561)this.method_25360());
        if (this.field_22763) {
            if (this.method_25370()) {
                narrationElementOutput.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.slider.usage.focused"));
            } else {
                narrationElementOutput.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.slider.usage.hovered"));
            }
        }
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_310 minecraft = class_310.method_1551();
        guiGraphics.method_52707(class_10799.field_56883, this.getSprite(), this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), class_9848.method_61317((float)this.field_22765));
        guiGraphics.method_52707(class_10799.field_56883, this.getHandleSprite(), this.method_46426() + (int)(this.delta * (double)(this.field_22758 - 8)), this.method_46427(), 8, this.method_25364(), class_9848.method_61317((float)this.field_22765));
        int k = this.field_22763 ? 0xFFFFFF : 0xA0A0A0;
        this.method_49604(guiGraphics, minecraft.field_1772, 2, k | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24);
    }

    public void method_25348(double mouseX, double mouseY) {
        this.setValueFromMouse(mouseX);
    }

    public void method_25365(boolean focused) {
        super.method_25365(focused);
        if (!focused) {
            this.canChangeValue = false;
        } else {
            class_8015 inputtype = class_310.method_1551().method_48186();
            if (inputtype == class_8015.field_41778 || inputtype == class_8015.field_41780) {
                this.canChangeValue = true;
            }
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (class_8494.method_51255((int)keyCode)) {
            this.canChangeValue = !this.canChangeValue;
            return true;
        }
        if (this.canChangeValue) {
            boolean flag;
            boolean bl = flag = keyCode == 263;
            if (flag || keyCode == 262) {
                float f = flag ? -1.0f : 1.0f;
                this.setValue(this.delta + (double)(f / (float)(this.field_22758 - 8)));
                return true;
            }
        }
        return false;
    }

    private void setValueFromMouse(double mouseX) {
        this.setValue((mouseX - (double)(this.method_46426() + 4)) / (double)(this.field_22758 - 8));
    }

    private void setValue(double value) {
        double d0 = this.delta;
        this.delta = class_3532.method_15350((double)value, (double)0.0, (double)1.0);
        this.value = this.deltaToValue();
        if (d0 != this.delta) {
            this.action.accept(this.value);
        }
        this.updateMessage();
    }

    private double deltaToValue() {
        double lerped = class_3532.method_16436((double)this.delta, (double)this.min, (double)this.max);
        return (double)Math.round(lerped * this.step) / this.step;
    }

    private double valueToDelta() {
        return (this.value - this.min) / (this.max - this.min);
    }

    protected void method_25349(double mouseX, double mouseY, double dragX, double dragY) {
        this.setValueFromMouse(mouseX);
        super.method_25349(mouseX, mouseY, dragX, dragY);
    }

    public void method_25354(class_1144 handler) {
    }

    public void method_25357(double mouseX, double mouseY) {
        super.method_25354(class_310.method_1551().method_1483());
    }

    private void updateMessage() {
        if (this.displayInt) {
            this.method_25355((class_2561)class_2561.method_43469((String)this.name, (Object[])new Object[]{(int)this.value}));
        } else {
            this.method_25355((class_2561)class_2561.method_43469((String)this.name, (Object[])new Object[]{this.value}));
        }
    }
}

