/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic.mixin;

import dev.worldgen.tectonic.Tectonic;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2806;
import net.minecraft.class_2852;
import net.minecraft.class_3218;
import net.minecraft.class_5455;
import net.minecraft.class_5539;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2852.class})
public abstract class SerializableChunkDataMixin {
    @Unique
    private static final Set<String> STATUSES_TO_SKIP_BLENDING = Set.of("minecraft:empty", "minecraft:structure_starts", "minecraft:structure_references", "minecraft:biomes");

    @Inject(method={"parse"}, at={@At(value="HEAD")})
    private static void tectonic$parse(class_5539 heightAccessor, class_5455 registryAccess, class_2487 nbt, CallbackInfoReturnable<class_2852> cir) {
        if (!((class_3218)heightAccessor).method_27983().equals(class_1937.field_25179)) {
            return;
        }
        if (STATUSES_TO_SKIP_BLENDING.contains(class_2806.method_12168((String)nbt.method_68564("Status", "unknown")).toString())) {
            return;
        }
        if (nbt.method_68083(Tectonic.BLENDING_KEY, 0) != Tectonic.BLENDING_VERSION) {
            int min = 0;
            int max = 0;
            class_2499 sections = nbt.method_68569("sections");
            for (class_2520 section : sections) {
                int n;
                if (section instanceof class_2497) {
                    class_2497 tag = (class_2497)section;
                    n = tag.method_10701();
                } else {
                    n = 0;
                }
                int y = n;
                min = Math.min(y, min);
                max = Math.max(y, max);
            }
            min = Math.min(min, -4);
            max = Math.max(max, 20);
            class_2487 blendingData = new class_2487();
            blendingData.method_10569("min_section", min);
            blendingData.method_10569("max_section", max);
            nbt.method_10566("blending_data", (class_2520)blendingData);
            nbt.method_10551("Heightmaps");
            nbt.method_10551("isLightOn");
        }
    }

    @Inject(method={"write"}, at={@At(value="RETURN")}, cancellable=true)
    private void tectonic$write(CallbackInfoReturnable<class_2487> cir) {
        if (Tectonic.BLENDING_VERSION == 0) {
            return;
        }
        class_2487 data = (class_2487)cir.getReturnValue();
        data.method_10569(Tectonic.BLENDING_KEY, Tectonic.BLENDING_VERSION);
        cir.setReturnValue((Object)data);
    }
}

