/*
 * Decompiled with CFR 0.152.
 */
package dev.rvbsm.fsit.lib.kaml;

import dev.rvbsm.fsit.lib.kaml.YamlNode;
import dev.rvbsm.fsit.lib.kaml.YamlPath;
import dev.rvbsm.fsit.lib.kaml.YamlScalar;
import dev.rvbsm.fsit.lib.kaml.YamlScalarFormatException;
import dev.rvbsm.fsit.lib.kaml.YamlScalarSerializer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=YamlScalarSerializer.class)
public final class YamlScalar
extends YamlNode {
    @NotNull
    private final String content;
    @NotNull
    private final YamlPath path;

    /*
     * WARNING - void declaration
     */
    public YamlScalar(@NotNull String content, @NotNull YamlPath path) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        super(path, (byte)0);
        this.content = var1_1;
        this.path = var2_2;
    }

    @NotNull
    public final String getContent() {
        return this.content;
    }

    @Override
    @NotNull
    public final YamlPath getPath() {
        return this.path;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equivalentContentTo(@NotNull YamlNode other) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return other instanceof YamlScalar && Intrinsics.areEqual((Object)this.content, (Object)((YamlScalar)var1_1).content);
    }

    @NotNull
    public final String contentToString() {
        return "'" + this.content + "'";
    }

    public final byte toByte() {
        return ((Number)this.convertToIntegerLikeValue(toByte.1.INSTANCE, "byte")).byteValue();
    }

    public final short toShort() {
        return ((Number)this.convertToIntegerLikeValue(toShort.1.INSTANCE, "short")).shortValue();
    }

    public final int toInt() {
        return ((Number)this.convertToIntegerLikeValue(toInt.1.INSTANCE, "integer")).intValue();
    }

    public final long toLong() {
        return ((Number)this.convertToIntegerLikeValue(toLong.1.INSTANCE, "long")).longValue();
    }

    @Nullable
    public final Long toLongOrNull$kaml() {
        return (Long)this.convertToIntegerLikeValueOrNull(toLongOrNull.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final <T> T convertToIntegerLikeValue(Function2<? super String, ? super Integer, ? extends T> converter, String description) {
        YamlScalar yamlScalar;
        T t = this.convertToIntegerLikeValueOrNull((Function2<? super String, ? super Integer, ? extends T>)yamlScalar);
        if (t == null) {
            void var2_2;
            yamlScalar = this;
            throw new YamlScalarFormatException("Value '" + this.content + "' is not a valid " + (String)var2_2 + " value.", yamlScalar.path, this.content);
        }
        return t;
    }

    private final <T> T convertToIntegerLikeValueOrNull(Function2<? super String, ? super Integer, ? extends T> converter) {
        Object object;
        try {
            Object object2;
            if (StringsKt.startsWith$default((String)this.content, (String)"0x", (boolean)false, (int)2, null)) {
                String string = this.content.substring(2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                object2 = converter.invoke((Object)string, (Object)16);
            } else if (StringsKt.startsWith$default((String)this.content, (String)"-0x", (boolean)false, (int)2, null)) {
                String string = this.content.substring(3);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                object2 = converter.invoke((Object)("-" + string), (Object)16);
            } else if (StringsKt.startsWith$default((String)this.content, (String)"0o", (boolean)false, (int)2, null)) {
                String string = this.content.substring(2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                object2 = converter.invoke((Object)string, (Object)8);
            } else if (StringsKt.startsWith$default((String)this.content, (String)"-0o", (boolean)false, (int)2, null)) {
                String string = this.content.substring(3);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                object2 = converter.invoke((Object)("-" + string), (Object)8);
            } else {
                object2 = object.invoke((Object)this.content, (Object)10);
            }
            object = object2;
        }
        catch (NumberFormatException numberFormatException) {
            object = null;
        }
        return (T)object;
    }

    public final float toFloat() {
        Object object;
        float f;
        switch (this.content) {
            case ".inf": 
            case ".Inf": 
            case ".INF": {
                return Float.POSITIVE_INFINITY;
            }
            case "-.inf": 
            case "-.Inf": 
            case "-.INF": {
                return Float.NEGATIVE_INFINITY;
            }
            case ".nan": 
            case ".NaN": 
            case ".NAN": {
                return Float.NaN;
            }
        }
        try {
            f = Float.parseFloat(this.content);
        }
        catch (NumberFormatException numberFormatException) {
            object = this;
            throw new YamlScalarFormatException("Value '" + this.content + "' is not a valid floating point value.", ((YamlScalar)object).path, this.content);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            object = this;
            throw new YamlScalarFormatException("Value '" + this.content + "' is not a valid floating point value.", ((YamlScalar)object).path, this.content);
        }
        return f;
    }

    public final double toDouble() {
        Double d = this.toDoubleOrNull$kaml();
        if (d != null) {
            return d;
        }
        YamlScalar yamlScalar = this;
        throw new YamlScalarFormatException("Value '" + this.content + "' is not a valid floating point value.", yamlScalar.path, this.content);
    }

    @Nullable
    public final Double toDoubleOrNull$kaml() {
        Object object;
        switch (this.content) {
            case ".inf": 
            case ".Inf": 
            case ".INF": {
                return Double.POSITIVE_INFINITY;
            }
            case "-.inf": 
            case "-.Inf": 
            case "-.INF": {
                return Double.NEGATIVE_INFINITY;
            }
            case ".nan": 
            case ".NaN": 
            case ".NAN": {
                return Double.NaN;
            }
        }
        try {
            object = Double.parseDouble(this.content);
        }
        catch (NumberFormatException numberFormatException) {
            object = null;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            object = null;
        }
        return object;
    }

    public final boolean toBoolean() {
        Boolean bl = this.toBooleanOrNull$kaml();
        if (bl != null) {
            return bl;
        }
        YamlScalar yamlScalar = this;
        throw new YamlScalarFormatException("Value '" + this.content + "' is not a valid boolean, permitted choices are: true or false", yamlScalar.path, this.content);
    }

    @Nullable
    public final Boolean toBooleanOrNull$kaml() {
        switch (this.content) {
            case "true": 
            case "True": 
            case "TRUE": {
                return Boolean.TRUE;
            }
            case "false": 
            case "FALSE": 
            case "False": {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public final char toChar() {
        Character c = this.toCharOrNull$kaml();
        if (c != null) {
            return c.charValue();
        }
        YamlScalar yamlScalar = this;
        throw new YamlScalarFormatException("Value '" + this.content + "' is not a valid character value.", yamlScalar.path, this.content);
    }

    @Nullable
    public final Character toCharOrNull$kaml() {
        return StringsKt.singleOrNull((CharSequence)this.content);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final YamlScalar withPath(@NotNull YamlPath newPath) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
        return YamlScalar.copy$default$3c9c14b3(this, null, (YamlPath)var1_1, 1);
    }

    @NotNull
    public final String toString() {
        YamlScalar yamlScalar = this;
        return "scalar @ " + yamlScalar.path + " : " + this.content;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static YamlScalar copy(@NotNull String content, @NotNull YamlPath path) {
        void var1_1;
        String string;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new YamlScalar(string, (YamlPath)var1_1);
    }

    private static /* synthetic */ YamlScalar copy$default$3c9c14b3(YamlScalar yamlScalar, String string, YamlPath yamlPath, int n) {
        string = yamlScalar.content;
        return YamlScalar.copy(string, yamlPath);
    }

    public final int hashCode() {
        int n = this.content.hashCode();
        n = n * 31 + this.path.hashCode();
        return n;
    }

    public final boolean equals(@Nullable Object other) {
        YamlScalar yamlScalar;
        if (this == other) {
            return true;
        }
        if (!(other instanceof YamlScalar)) {
            return false;
        }
        yamlScalar = yamlScalar;
        if (!Intrinsics.areEqual((Object)this.content, (Object)yamlScalar.content)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.path, (Object)yamlScalar.path);
    }

    static {
        new Companion(null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003"}, d2={"Ldev/rvbsm/fsit/lib/kaml/YamlScalar$Companion;", "", "<init>", "()V"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

