/*
 * Decompiled with CFR 0.152.
 */
package dev.rvbsm.fsit.lib.okio;

import dev.rvbsm.fsit.lib.okio.Segment;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u000bH\u0002\u00a2\u0006\u0004\b\f\u0010\rR\u0011\u0010\u000f\u001a\u00020\u000e8\u0006\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u000e8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0010R\"\u0010\u0015\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u000b0\u00148\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016"}, d2={"Ldev/rvbsm/fsit/lib/okio/SegmentPool;", "", "<init>", "()V", "Ldev/rvbsm/fsit/lib/okio/Segment;", "take", "()Ldev/rvbsm/fsit/lib/okio/Segment;", "segment", "", "recycle", "(Ldev/rvbsm/fsit/lib/okio/Segment;)V", "Ljava/util/concurrent/atomic/AtomicReference;", "firstRef", "()Ljava/util/concurrent/atomic/AtomicReference;", "", "MAX_SIZE", "I", "LOCK", "Ldev/rvbsm/fsit/lib/okio/Segment;", "HASH_BUCKET_COUNT", "", "hashBuckets", "[Ljava/util/concurrent/atomic/AtomicReference;"})
public final class SegmentPool {
    @NotNull
    public static final SegmentPool INSTANCE = new SegmentPool();
    public static int MAX_SIZE = 65536;
    @NotNull
    private static final Segment LOCK = new Segment(new byte[0], 0, 0, false, false);
    private static final int HASH_BUCKET_COUNT = Integer.highestOneBit((Runtime.getRuntime().availableProcessors() << 1) - 1);
    @NotNull
    private static final AtomicReference<Segment>[] hashBuckets;

    private SegmentPool() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Segment take() {
        void var1_1;
        void var0;
        AtomicReference<Segment> firstRef = SegmentPool.firstRef();
        Segment first = firstRef.getAndSet(LOCK);
        if (first == LOCK) {
            return new Segment();
        }
        if (first == null) {
            firstRef.set(null);
            return new Segment();
        }
        var0.set(first.next);
        first.next = null;
        first.limit = 0;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void recycle(@NotNull Segment segment) {
        Segment segment2;
        void var1_3;
        void var3_4;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        if (!(segment.next == null && segment.prev == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (segment.shared) {
            return;
        }
        AtomicReference<Segment> firstRef = SegmentPool.firstRef();
        Segment first = firstRef.getAndSet(LOCK);
        if (first == LOCK) {
            return;
        }
        Segment segment3 = first;
        int firstLimit = segment3 != null ? segment3.limit : 0;
        if (firstLimit >= MAX_SIZE) {
            firstRef.set(first);
            return;
        }
        segment.next = var2_2;
        segment.pos = 0;
        segment.limit = var3_4 + 8192;
        var1_3.set(segment2);
    }

    /*
     * WARNING - void declaration
     */
    private static AtomicReference<Segment> firstRef() {
        void var0;
        int hashBucket = (int)(Thread.currentThread().getId() & (long)HASH_BUCKET_COUNT - 1L);
        return hashBuckets[var0];
    }

    static {
        int n = 0;
        int n2 = HASH_BUCKET_COUNT;
        AtomicReference[] atomicReferenceArray = new AtomicReference[n2];
        while (n < n2) {
            int n3 = n++;
            atomicReferenceArray[n3] = new AtomicReference();
        }
        hashBuckets = atomicReferenceArray;
    }
}

