/*
 * Decompiled with CFR 0.152.
 */
package dev.rvbsm.fsit.lib.snakeyaml-kmp.api;

import dev.rvbsm.fsit.lib.snakeyaml-kmp.api.ConstructNode;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.api.LoadSettings;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.common.SpecVersion;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.env.EnvConfig;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.exceptions.YamlVersionException;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.nodes.Tag;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.schema.JsonSchema;
import dev.rvbsm.fsit.lib.snakeyaml-kmp.schema.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LoadSettingsBuilder {
    @NotNull
    private final Map<Object, Object> customProperties = new HashMap();
    @NotNull
    private String label = "reader";
    @NotNull
    private Map<Tag, ? extends ConstructNode> tagConstructors = new LinkedHashMap();
    @NotNull
    private LoadSettings.CollectionProvider<List<Object>> defaultList = LoadSettingsBuilder::defaultList$lambda$0;
    @NotNull
    private LoadSettings.CollectionProvider<Set<Object>> defaultSet = LoadSettingsBuilder::defaultSet$lambda$1;
    @NotNull
    private LoadSettings.CollectionProvider<Map<Object, Object>> defaultMap = LoadSettingsBuilder::defaultMap$lambda$2;
    @NotNull
    private LoadSettings.SpecVersionMutator versionFunction = LoadSettingsBuilder::versionFunction$lambda$3;
    private int bufferSize = 1024;
    private boolean allowDuplicateKeys;
    private boolean allowRecursiveKeys;
    private boolean parseComments;
    private int maxAliasesForCollections = 50;
    private boolean useMarks = true;
    @Nullable
    private EnvConfig envConfig;
    private int codePointLimit = 0x300000;
    @NotNull
    private Schema schema = new JsonSchema(null, null, 3);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LoadSettingsBuilder setLabel(@NotNull String label) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        this.label = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LoadSettingsBuilder setCodePointLimit(int codePointLimit) {
        void var1_1;
        this.codePointLimit = var1_1;
        return this;
    }

    @NotNull
    public final LoadSettings build() {
        return new LoadSettings(this.label, this.tagConstructors, this.defaultList, this.defaultSet, this.defaultMap, this.versionFunction, this.bufferSize, this.allowDuplicateKeys, this.allowRecursiveKeys, this.maxAliasesForCollections, this.useMarks, this.customProperties, this.envConfig, this.parseComments, this.codePointLimit, this.schema);
    }

    private static final List defaultList$lambda$0(int initialCapacity) {
        int n;
        return new ArrayList(n);
    }

    private static final Set defaultSet$lambda$1(int initialCapacity) {
        int n;
        return new LinkedHashSet(n);
    }

    private static final Map defaultMap$lambda$2(int initialCapacity) {
        int n;
        return new LinkedHashMap(n);
    }

    private static final SpecVersion versionFunction$lambda$3(SpecVersion version) {
        SpecVersion specVersion;
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        if (version.getMajor() != 1) {
            throw new YamlVersionException(version);
        }
        return specVersion;
    }
}

