/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.generators;

import com.supermartijn642.formations.generators.StructureSetKey;
import com.supermartijn642.formations.generators.properties.PiecedStructureProperties;
import com.supermartijn642.formations.generators.properties.SimpleStructureProperties;
import com.supermartijn642.formations.generators.properties.StructureProperties;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1959;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5847;

public class StructureConfiguration {
    final String namespace;
    final String identifier;
    StructureProperties typeProperties;
    Set<class_2960> biomes = new LinkedHashSet<class_2960>();
    Set<class_2960> biomeTags = new LinkedHashSet<class_2960>();
    class_2893.class_2895 generationStep = class_2893.class_2895.field_13173;
    class_5847 terrainAdjustment = class_5847.field_38431;
    StructureSetKey structureSet;
    int weight = 1;

    public static StructureConfiguration create(String namespace, String identifier) {
        return new StructureConfiguration(namespace, identifier);
    }

    private StructureConfiguration(String namespace, String identifier) {
        this.namespace = namespace;
        this.identifier = identifier;
    }

    private <T extends StructureProperties> StructureConfiguration type(T properties, Consumer<T> propertiesConsumer) {
        if (this.typeProperties != null) {
            throw new IllegalStateException("Type has already been set!");
        }
        propertiesConsumer.accept(properties);
        this.typeProperties = properties;
        return this;
    }

    public StructureConfiguration simpleType(Consumer<SimpleStructureProperties> propertiesConsumer) {
        return this.type(new SimpleStructureProperties(this.namespace), propertiesConsumer);
    }

    public StructureConfiguration piecedType(Consumer<PiecedStructureProperties> propertiesConsumer) {
        return this.type(new PiecedStructureProperties(this.namespace), propertiesConsumer);
    }

    public StructureConfiguration biomes(class_2960 ... biomes) {
        this.biomes.addAll(Arrays.asList(biomes));
        return this;
    }

    public StructureConfiguration biomes(class_5321<class_1959> ... biomes) {
        Arrays.stream(biomes).map(class_5321::method_29177).forEach(this.biomes::add);
        return this;
    }

    public StructureConfiguration biomeTags(class_2960 ... tags) {
        this.biomeTags.addAll(Arrays.asList(tags));
        return this;
    }

    public StructureConfiguration generationStep(class_2893.class_2895 step) {
        this.generationStep = step;
        return this;
    }

    public StructureConfiguration terrainAdjustment(class_5847 adjustment) {
        this.terrainAdjustment = adjustment;
        return this;
    }

    public StructureConfiguration set(StructureSetKey key) {
        this.structureSet = key;
        return this;
    }

    public StructureConfiguration weight(int weight) {
        this.weight = weight;
        return this;
    }
}

