/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.structure.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.supermartijn642.formations.FormationsStructures;
import com.supermartijn642.formations.structure.BlockInstance;
import com.supermartijn642.formations.structure.FormationsStructureProcessor;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3542;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import org.jetbrains.annotations.NotNull;

public class WaterloggingProcessor
extends class_3491
implements FormationsStructureProcessor {
    public static final MapCodec<WaterloggingProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)WaterHandling.CODEC.optionalFieldOf("handling", (Object)WaterHandling.TAKE_STRUCTURE).forGetter(p -> p.waterHandling)).apply((Applicative)instance, WaterloggingProcessor::new));
    private final WaterHandling waterHandling;

    public WaterloggingProcessor(WaterHandling waterHandling) {
        this.waterHandling = waterHandling;
    }

    @Override
    @NotNull
    public BlockInstance processBlock(BlockInstance block, class_2338 pos, class_4538 level, class_2338 piecePosition, class_2338 structurePosition, class_3492 placeSettings, Map<class_2338, BlockInstance> pieceBlocks) {
        class_2680 state = block.state();
        if (state != null && state.method_28498((class_2769)class_2741.field_12508)) {
            boolean structureWaterlogged;
            boolean waterlogged = (Boolean)state.method_11654((class_2769)class_2741.field_12508);
            if (this.waterHandling == WaterHandling.DRY) {
                return waterlogged ? new BlockInstance((class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)), block.nbt()) : block;
            }
            if (this.waterHandling == WaterHandling.WET) {
                return waterlogged ? block : new BlockInstance((class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true)), block.nbt());
            }
            class_2680 structureState = pieceBlocks.get(pos).state();
            boolean bl = structureWaterlogged = structureState != null && structureState.method_26227().method_39360((class_3611)class_3612.field_15910);
            if (this.waterHandling == WaterHandling.TAKE_STRUCTURE) {
                return waterlogged == structureWaterlogged ? block : new BlockInstance((class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(structureWaterlogged)), block.nbt());
            }
            boolean worldWaterlogged = level.method_8316(pos).method_39360((class_3611)class_3612.field_15910);
            if (this.waterHandling == WaterHandling.TAKE_WORLD) {
                return waterlogged == worldWaterlogged ? block : new BlockInstance((class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(worldWaterlogged)), block.nbt());
            }
            if (this.waterHandling == WaterHandling.WORLD_OR_STRUCTURE_WET) {
                return waterlogged == (worldWaterlogged || structureWaterlogged) ? block : new BlockInstance((class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(worldWaterlogged || structureWaterlogged)), block.nbt());
            }
            if (this.waterHandling == WaterHandling.WORLD_OR_STRUCTURE_DRY) {
                return waterlogged == (worldWaterlogged && structureWaterlogged) ? block : new BlockInstance((class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(worldWaterlogged && structureWaterlogged)), block.nbt());
            }
        }
        return block;
    }

    protected class_3828<?> method_16772() {
        return FormationsStructures.WATERLOGGING_PROCESSOR;
    }

    public static enum WaterHandling implements class_3542
    {
        DRY,
        WET,
        TAKE_WORLD,
        TAKE_STRUCTURE,
        WORLD_OR_STRUCTURE_WET,
        WORLD_OR_STRUCTURE_DRY;

        static final Codec<WaterHandling> CODEC;

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = class_3542.method_28140(WaterHandling::values);
        }
    }
}

