/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.tools.template;

import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.formations.Formations;
import com.supermartijn642.formations.FormationsDev;
import com.supermartijn642.formations.extensions.TemplateHoldingLevel;
import com.supermartijn642.formations.tools.template.Template;
import com.supermartijn642.formations.tools.template.packets.AllTemplatesPacket;
import com.supermartijn642.formations.tools.template.packets.DeleteTemplatePacket;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class TemplateManager {
    private final class_1937 level;
    private final boolean isClientSide;
    private final Set<Template> templates = new HashSet<Template>();
    private final Map<class_238, Template> templatesByArea = new HashMap<class_238, Template>();
    private final Map<String, Template> templatesByName = new HashMap<String, Template>();
    private final Set<String> removedTemplates = new HashSet<String>();

    public static TemplateManager get(class_1937 level) {
        return ((TemplateHoldingLevel)level).getFormationsTemplateManager();
    }

    public static void registerListeners() {
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, origin, destination) -> TemplateManager.get((class_1937)origin).sendTemplatesToPlayer((class_1657)player));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> TemplateManager.get((class_1937)handler.field_14140.method_51469()).sendTemplatesToPlayer((class_1657)handler.field_14140));
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> TemplateManager.get((class_1937)newPlayer.method_51469()).sendTemplatesToPlayer((class_1657)newPlayer));
    }

    public TemplateManager(class_1937 level) {
        this.level = level;
        this.isClientSide = level.field_9236;
    }

    public void addTemplate(Template template) {
        if (this.templatesByArea.containsKey(template.getArea())) {
            Template oldTemplate = this.templatesByArea.get(template.getArea());
            this.templates.remove(oldTemplate);
            this.templatesByName.remove(oldTemplate.getName());
            this.removedTemplates.add(oldTemplate.getName());
        }
        this.templates.add(template);
        this.templatesByArea.put(template.getArea(), template);
        this.templatesByName.put(template.getName(), template);
        if (!this.isClientSide) {
            this.sendAllTemplates();
        }
    }

    public Template getTemplateByName(String name) {
        return this.templatesByName.get(name);
    }

    public Set<Template> getAllTemplates() {
        return Collections.unmodifiableSet(this.templates);
    }

    public void removeTemplate(Template template) {
        this.templates.remove(template);
        this.templatesByName.remove(template.getName());
        this.templatesByArea.remove(template.getArea());
        this.removedTemplates.add(template.getName());
        if (!this.isClientSide) {
            FormationsDev.CHANNEL.sendToDimension(this.level, (BasePacket)new DeleteTemplatePacket(template));
        }
    }

    public void clearAll() {
        this.templates.clear();
        this.templatesByArea.clear();
        this.templatesByName.clear();
        this.removedTemplates.clear();
    }

    private void sendTemplatesToPlayer(class_1657 player) {
        if (this.isClientSide) {
            throw new AssertionError();
        }
        FormationsDev.CHANNEL.sendToPlayer(player, (BasePacket)new AllTemplatesPacket(this.templates));
    }

    private void sendAllTemplates() {
        if (this.isClientSide) {
            throw new AssertionError();
        }
        FormationsDev.CHANNEL.sendToDimension(this.level, (BasePacket)new AllTemplatesPacket(this.templates));
    }

    public Pair<Integer, Integer> exportAll() {
        if (this.isClientSide) {
            throw new AssertionError();
        }
        String pathProperty = System.getProperty("formations.templates.export-location");
        Path path = pathProperty != null && !pathProperty.isBlank() ? Paths.get(pathProperty.trim(), new String[0]) : this.level.method_8503().field_23784.method_27424(this.level.method_27983()).resolve("formations").resolve("templates");
        this.removedTemplates.removeAll(this.templatesByName.keySet());
        for (String removedTemplate : this.removedTemplates) {
            Path file = path.resolve(removedTemplate + ".nbt");
            try {
                Files.deleteIfExists(file);
            }
            catch (IOException e) {
                Formations.LOGGER.error("Failed to remove file '" + String.valueOf(file) + "' for removed a template:", (Throwable)e);
            }
        }
        int successes = 0;
        int fails = 0;
        for (Template template : this.templates) {
            Path file = path.resolve(template.getName() + ".nbt");
            try {
                if (template.recordAndExport(this.level, file)) {
                    ++successes;
                    continue;
                }
                ++fails;
            }
            catch (Exception e) {
                Formations.LOGGER.error("Failed to capture and save template '" + template.getName() + "':", (Throwable)e);
                ++fails;
            }
        }
        return Pair.of((Object)successes, (Object)fails);
    }

    class_2487 write() {
        if (this.isClientSide) {
            throw new AssertionError();
        }
        class_2487 data = new class_2487();
        class_2499 templates = new class_2499();
        this.templates.stream().map(Template::write).forEach(arg_0 -> templates.add(arg_0));
        data.method_10566("templates", (class_2520)templates);
        class_2499 removedTemplates = new class_2499();
        this.removedTemplates.stream().map(class_2519::method_23256).forEach(arg_0 -> removedTemplates.add(arg_0));
        data.method_10566("removedTemplates", (class_2520)removedTemplates);
        return data;
    }

    void read(class_2487 data) {
        if (this.isClientSide) {
            throw new AssertionError();
        }
        this.clearAll();
        class_2499 templates = data.method_68569("templates");
        templates.stream().filter(class_2487.class::isInstance).map(class_2487.class::cast).map(Template::load).forEach(this.templates::add);
        this.templates.forEach(template -> this.templatesByArea.put(template.getArea(), (Template)template));
        this.templates.forEach(template -> this.templatesByName.put(template.getName(), (Template)template));
        class_2499 removedTemplates = data.method_68569("removedTemplates");
        removedTemplates.stream().filter(class_2519.class::isInstance).map(class_2519.class::cast).map(class_2519::method_68658).filter(Optional::isPresent).map(Optional::get).forEach(this.removedTemplates::add);
    }
}

