/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cristelknight.cristellib.CristelLib;
import de.cristelknight.cristellib.CristelLibExpectPlatform;
import de.cristelknight.cristellib.config.ConfigManager;
import de.cristelknight.cristellib.config.ConfigType;
import de.cristelknight.cristellib.config.serialize.placement.PlacementConfig;
import de.cristelknight.cristellib.data.codec.StructureSetData;
import de.cristelknight.cristellib.registry.ReadStructureSets;
import de.cristelknight.cristellib.util.JanksonUtil;
import de.cristelknight.cristellib.util.RuntimePackUtil;
import de.cristelknight.cristellib.util.Util;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;

public class StructureConfig {
    public static final Codec<StructureConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("name").forGetter(config -> Util.fileName(config.getPath())), (App)Codec.STRING.fieldOf("path").forGetter(config -> String.valueOf(config.path.getParent())), (App)Codec.STRING.optionalFieldOf("header", (Object)"").forGetter(config -> config.header), (App)ConfigType.CODEC.fieldOf("config_type").forGetter(config -> config.type), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).optionalFieldOf("comments", new HashMap()).forGetter(config -> config.comments), (App)Codec.list(StructureSetData.CODEC).fieldOf("structure_sets").forGetter(config -> config.structureSetHolders)).apply((Applicative)builder, StructureConfig::new));
    private final Path path;
    private String header = "";
    private Map<String, String> comments;
    private final ConfigType type;
    private final List<StructureSetData> structureSetHolders;
    private final Supplier<Map<class_2960, List<String>>> structuresForED;
    private final Supplier<Map<String, PlacementConfig>> structurePlacement;
    private Map<String, Boolean> enableDisableConfig = null;
    private Map<String, PlacementConfig> placementConfig = null;

    private StructureConfig(Path path, ConfigType type) {
        this(path, null, new HashMap<String, String>(), type, new ArrayList<StructureSetData>());
    }

    private StructureConfig(String name, String path, String header, ConfigType type, Map<String, String> comments, List<StructureSetData> structureSetHolders) {
        this(Util.janksonPathFromString(path, name), header, (Map<String, String>)ImmutableMap.copyOf(comments), type, (List<StructureSetData>)ImmutableList.copyOf(structureSetHolders));
    }

    private StructureConfig(Path path, String header, Map<String, String> comments, ConfigType type, List<StructureSetData> structureSetHolders) {
        this.path = path;
        if (header != null && !header.isEmpty()) {
            this.setHeader(header);
        }
        this.comments = comments;
        this.type = type;
        this.structureSetHolders = structureSetHolders;
        this.structuresForED = Suppliers.memoize(() -> ReadStructureSets.readSetsAndAddStructures(structureSetHolders));
        this.structurePlacement = Suppliers.memoize(() -> ReadStructureSets.readSetsAndAddPlacements(structureSetHolders));
    }

    void addSet(StructureSetData set) {
        this.structureSetHolders.add(set);
    }

    void addSetsToRuntimePack() {
        if (this.type.equals((Object)ConfigType.ENABLE_DISABLE)) {
            this.enableDisableConfig = ConfigManager.readEDConfig(this);
        } else {
            this.placementConfig = ConfigManager.readPlacementConfig(this);
        }
        this.structureSetHolders.forEach(holder -> holder.sets().forEach(setLocation -> {
            String modID = holder.modID();
            JsonElement structureSetElement = this.getStructureSet((class_2960)setLocation, modID);
            if (!(structureSetElement instanceof JsonObject)) {
                CristelLib.LOGGER.warn("Set for {} {} is not a JsonObject, skipping...", (Object)modID, setLocation);
                return;
            }
            JsonObject structureSet = (JsonObject)structureSetElement;
            JsonObject originalSet = structureSet.deepCopy();
            if (this.type.equals((Object)ConfigType.ENABLE_DISABLE)) {
                this.removeStructureInSets(structureSet);
            } else if (this.type.equals((Object)ConfigType.PLACEMENT)) {
                this.updatePlacementsInSet(structureSet, (class_2960)setLocation);
            }
            if (!structureSet.equals((Object)originalSet)) {
                CristelLib.DATA_PACK.addStructureSet((class_2960)setLocation, structureSet);
            }
        }));
    }

    private void removeStructureInSets(JsonObject structureSet) {
        JsonArray array = structureSet.get("structures").getAsJsonArray();
        Iterator structureIterator = array.iterator();
        while (structureIterator.hasNext()) {
            JsonElement structure = (JsonElement)structureIterator.next();
            String structureName = structure.getAsJsonObject().get("structure").getAsString().split(":")[1];
            if (!this.enableDisableConfig.containsKey(structureName) || this.enableDisableConfig.get(structureName).booleanValue()) continue;
            structureIterator.remove();
        }
    }

    private void updatePlacementsInSet(JsonObject structureSet, class_2960 setLocation) {
        String structureSetName = setLocation.method_12832();
        if (this.placementConfig.containsKey(structureSetName)) {
            JsonObject a = structureSet.get("placement").getAsJsonObject();
            PlacementConfig p = this.placementConfig.get(structureSetName);
            a.addProperty("salt", (Number)p.salt());
            a.addProperty("spacing", (Number)p.spacing());
            a.addProperty("separation", (Number)p.separation());
            double f = p.frequency();
            if (f != 0.0 && a.has("frequency") && (double)a.get("frequency").getAsFloat() != f) {
                a.addProperty("frequency", (Number)f);
            }
        }
    }

    private JsonElement getStructureSet(class_2960 location, String modID) {
        class_2960 structureLocation = RuntimePackUtil.getLocationForStructureSet(location);
        if (CristelLib.DATA_PACK.hasResource(structureLocation)) {
            return CristelLib.DATA_PACK.getResource(structureLocation);
        }
        return JanksonUtil.getSetElement(modID, location);
    }

    void writeConfig() {
        if (this.type.equals((Object)ConfigType.ENABLE_DISABLE)) {
            ConfigManager.createEDConfig(this, false);
        } else if (this.type.equals((Object)ConfigType.PLACEMENT)) {
            ConfigManager.createPlacementConfig(this, false);
        }
    }

    public static StructureConfig create(Path path, String name, ConfigType type) {
        return new StructureConfig(path.resolve(name + ".json5"), type);
    }

    public static StructureConfig createWithDefaultConfigPath(String subPath, String name, ConfigType type) {
        return new StructureConfig(CristelLibExpectPlatform.getConfigDirectory().resolve(subPath).resolve(name + ".json5"), type);
    }

    public static StructureConfig createWithDefaultConfigPath(String name, ConfigType type) {
        return new StructureConfig(CristelLibExpectPlatform.getConfigDirectory().resolve(name + ".json5"), type);
    }

    public void setComments(Map<String, String> comments) {
        this.comments = comments;
    }

    public void setHeader(String header) {
        this.header = ConfigManager.createHeader(header);
    }

    public String getHeader() {
        return this.header;
    }

    public Map<String, String> getComments() {
        return this.comments;
    }

    public Map<class_2960, List<String>> getStructures() {
        return (Map)this.structuresForED.get();
    }

    public Map<String, PlacementConfig> getStructurePlacement() {
        return (Map)this.structurePlacement.get();
    }

    public Path getPath() {
        return this.path;
    }
}

