/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib.fabric;

import de.cristelknight.cristellib.CristelLib;
import de.cristelknight.cristellib.CristelLibRegistry;
import de.cristelknight.cristellib.StructureConfig;
import de.cristelknight.cristellib.api.CristelLibAPI;
import de.cristelknight.cristellib.data.ReadData;
import de.cristelknight.cristellib.util.Platform;
import de.cristelknight.cristellib.util.Util;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.fabric.impl.resource.loader.ModNioResourcePack;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import org.jetbrains.annotations.Nullable;

public class CristelLibExpectPlatformImpl {
    public static Path getConfigDirectory() {
        return FabricLoader.getInstance().getConfigDir();
    }

    public static class_3262 registerBuiltinResourcePack(class_2960 id, class_2561 displayName) {
        String modID = id.method_12836();
        ModContainer container = FabricLoader.getInstance().getModContainer(modID).orElse(null);
        if (container != null) {
            return ModNioResourcePack.create((String)id.toString(), (ModContainer)container, (String)id.method_12832(), (class_3264)class_3264.field_14190, (ResourcePackActivationType)ResourcePackActivationType.ALWAYS_ENABLED, (boolean)false);
        }
        CristelLib.LOGGER.warn("Couldn't get mod container for modID: {}", (Object)modID);
        return null;
    }

    @Nullable
    public static Path getResourceDirectory(String modid, String subPath) {
        ModContainer container = FabricLoader.getInstance().getModContainer(modid).orElse(null);
        if (container != null) {
            Path path = container.findPath(subPath).orElse(null);
            if (path == null) {
                CristelLib.LOGGER.debug("Path for subPath: {} in modId: {} is null", (Object)subPath, (Object)modid);
            }
            return path;
        }
        CristelLib.LOGGER.debug("Mod container for modId: {} is null", (Object)modid);
        return null;
    }

    public static Map<String, Set<StructureConfig>> getConfigs(CristelLibRegistry registry) {
        HashMap<String, Set<StructureConfig>> configs = new HashMap<String, Set<StructureConfig>>();
        FabricLoader.getInstance().getEntrypointContainers("cristellib", CristelLibAPI.class).forEach(entrypoint -> {
            String modId = entrypoint.getProvider().getMetadata().getId();
            try {
                CristelLibAPI api = (CristelLibAPI)entrypoint.getEntrypoint();
                HashSet<StructureConfig> set = new HashSet<StructureConfig>();
                api.registerConfigs(set);
                configs.put(modId, set);
                api.registerStructureSets(registry);
            }
            catch (Throwable e) {
                CristelLib.LOGGER.error("Mod: {} provides a broken implementation of CristelLibAPI", (Object)modId, (Object)e);
            }
        });
        Util.addAll(configs, CristelLibExpectPlatformImpl.data());
        return configs;
    }

    public static Map<String, Set<StructureConfig>> data() {
        HashMap<String, Set<StructureConfig>> modidAndConfigs = new HashMap<String, Set<StructureConfig>>();
        for (ModContainer container : FabricLoader.getInstance().getAllMods()) {
            String modid = container.getMetadata().getId();
            ReadData.getBuiltInPacks(modid);
            ReadData.copyFile(modid);
            ReadData.getStructureConfigs(modid, modidAndConfigs);
        }
        return modidAndConfigs;
    }

    public static List<Path> getRootPaths(String modId) {
        ModContainer container = FabricLoader.getInstance().getModContainer(modId).orElse(null);
        List<Path> paths = new ArrayList<Path>();
        if (container != null) {
            paths = container.getRootPaths();
        }
        return paths;
    }

    public static Platform getPlatform() {
        return Platform.FABRIC;
    }
}

