/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.fabric;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import me.lucko.spark.common.platform.world.AbstractChunkInfo;
import me.lucko.spark.common.platform.world.CountMap;
import me.lucko.spark.common.platform.world.WorldInfoProvider;
import me.lucko.spark.fabric.mixin.ClientEntityManagerAccessor;
import me.lucko.spark.fabric.mixin.ClientWorldAccessor;
import me.lucko.spark.fabric.mixin.ServerEntityManagerAccessor;
import me.lucko.spark.fabric.mixin.ServerWorldAccessor;
import me.lucko.spark.fabric.mixin.WorldAccessor;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3283;
import net.minecraft.class_5352;
import net.minecraft.class_5570;
import net.minecraft.class_5577;
import net.minecraft.class_5579;
import net.minecraft.class_5582;
import net.minecraft.class_638;
import net.minecraft.server.MinecraftServer;

public abstract class FabricWorldInfoProvider
implements WorldInfoProvider {
    protected abstract class_3283 getResourcePackManager();

    @Override
    public Collection<WorldInfoProvider.DataPackInfo> pollDataPacks() {
        return this.getResourcePackManager().method_14444().stream().map(pack -> new WorldInfoProvider.DataPackInfo(pack.method_14463(), pack.method_14459().getString(), FabricWorldInfoProvider.resourcePackSource(pack.method_29483()))).collect(Collectors.toList());
    }

    private static String resourcePackSource(class_5352 source) {
        if (source == class_5352.field_25347) {
            return "none";
        }
        if (source == class_5352.field_25348) {
            return "builtin";
        }
        if (source == class_5352.field_25349) {
            return "world";
        }
        if (source == class_5352.field_25350) {
            return "server";
        }
        return "unknown";
    }

    private static final class MoonriseMethods {
        private static Method getEntityCount;

        private MoonriseMethods() {
        }

        private static Method getEntityCountMethod(class_5577<class_1297> getter) {
            if (getEntityCount == null) {
                try {
                    getEntityCount = getter.getClass().getMethod("getEntityCount", new Class[0]);
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException("Cannot find Moonrise getEntityCount method", e);
                }
            }
            return getEntityCount;
        }

        private static int getEntityCount(class_5577<class_1297> getter) {
            try {
                return (Integer)MoonriseMethods.getEntityCountMethod(getter).invoke(getter, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Failed to invoke Moonrise getEntityCount method", e);
            }
        }
    }

    static final class FabricChunkInfo
    extends AbstractChunkInfo<class_1299<?>> {
        private final CountMap<class_1299<?>> entityCounts = new CountMap.Simple(new HashMap());

        FabricChunkInfo(long chunkPos) {
            super(class_1923.method_8325((long)chunkPos), class_1923.method_8332((long)chunkPos));
        }

        @Override
        public CountMap<class_1299<?>> getEntityCounts() {
            return this.entityCounts;
        }

        @Override
        public String entityTypeName(class_1299<?> type) {
            return class_1299.method_5890(type).toString();
        }
    }

    public static final class Client
    extends FabricWorldInfoProvider {
        private final class_310 client;

        public Client(class_310 client) {
            this.client = client;
        }

        @Override
        public WorldInfoProvider.CountsResult pollCounts() {
            int entities;
            class_638 world = this.client.field_1687;
            if (world == null) {
                return null;
            }
            if (FabricLoader.getInstance().isModLoaded("moonrise")) {
                entities = MoonriseMethods.getEntityCount(((WorldAccessor)world).spark$getEntityLookup());
            } else {
                class_5582<class_1297> entityManager = ((ClientWorldAccessor)world).getEntityManager();
                class_5570<?> entityIndex = ((ClientEntityManagerAccessor)entityManager).getIndex();
                entities = entityIndex.method_31756();
            }
            int chunks = world.method_2935().method_14151();
            return new WorldInfoProvider.CountsResult(-1, entities, -1, chunks);
        }

        public WorldInfoProvider.ChunksResult<FabricChunkInfo> pollChunks() {
            class_638 world = this.client.field_1687;
            if (world == null) {
                return null;
            }
            WorldInfoProvider.ChunksResult<FabricChunkInfo> data = new WorldInfoProvider.ChunksResult<FabricChunkInfo>();
            Long2ObjectOpenHashMap worldInfos = new Long2ObjectOpenHashMap();
            for (class_1297 entity : ((WorldAccessor)world).spark$getEntityLookup().method_31803()) {
                FabricChunkInfo info = (FabricChunkInfo)worldInfos.computeIfAbsent(entity.method_31476().method_8324(), FabricChunkInfo::new);
                info.entityCounts.increment(entity.method_5864());
            }
            data.put(world.method_27983().method_29177().method_12832(), List.copyOf(worldInfos.values()));
            return data;
        }

        @Override
        public WorldInfoProvider.GameRulesResult pollGameRules() {
            return null;
        }

        @Override
        protected class_3283 getResourcePackManager() {
            return this.client.method_1520();
        }
    }

    public static final class Server
    extends FabricWorldInfoProvider {
        private final MinecraftServer server;

        public Server(MinecraftServer server) {
            this.server = server;
        }

        @Override
        public WorldInfoProvider.CountsResult pollCounts() {
            int players = this.server.method_3788();
            int entities = 0;
            int chunks = 0;
            for (class_3218 world : this.server.method_3738()) {
                if (FabricLoader.getInstance().isModLoaded("moonrise")) {
                    entities += MoonriseMethods.getEntityCount(((WorldAccessor)world).spark$getEntityLookup());
                } else {
                    class_5579<class_1297> entityManager = ((ServerWorldAccessor)world).getEntityManager();
                    class_5570<?> entityIndex = ((ServerEntityManagerAccessor)entityManager).getIndex();
                    entities += entityIndex.method_31756();
                }
                chunks += world.method_14178().method_14151();
            }
            return new WorldInfoProvider.CountsResult(players, entities, -1, chunks);
        }

        public WorldInfoProvider.ChunksResult<FabricChunkInfo> pollChunks() {
            WorldInfoProvider.ChunksResult<FabricChunkInfo> data = new WorldInfoProvider.ChunksResult<FabricChunkInfo>();
            for (class_3218 world : this.server.method_3738()) {
                Long2ObjectOpenHashMap worldInfos = new Long2ObjectOpenHashMap();
                for (class_1297 entity : ((WorldAccessor)world).spark$getEntityLookup().method_31803()) {
                    FabricChunkInfo info = (FabricChunkInfo)worldInfos.computeIfAbsent(entity.method_31476().method_8324(), FabricChunkInfo::new);
                    info.entityCounts.increment(entity.method_5864());
                }
                data.put(world.method_27983().method_29177().method_12832(), List.copyOf(worldInfos.values()));
            }
            return data;
        }

        @Override
        public WorldInfoProvider.GameRulesResult pollGameRules() {
            final WorldInfoProvider.GameRulesResult data = new WorldInfoProvider.GameRulesResult();
            Iterable worlds = this.server.method_3738();
            for (final class_3218 world : worlds) {
                final String worldName = world.method_27983().method_29177().method_12832();
                world.method_64395().method_20744(new class_1928.class_4311(){

                    public <T extends class_1928.class_4315<T>> void method_20762(class_1928.class_4313<T> key, class_1928.class_4314<T> type) {
                        String defaultValue = type.method_20773().method_20779();
                        data.putDefault(key.method_20771(), defaultValue);
                        String value = world.method_64395().method_20746(key).method_20779();
                        data.put(key.method_20771(), worldName, value);
                    }
                });
            }
            return data;
        }

        @Override
        protected class_3283 getResourcePackManager() {
            return this.server.method_3836();
        }
    }
}

