/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.impl;

import java.io.IOException;
import java.util.List;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.bookshelf.common.impl.Constants;

public class BookshelfMod {
    private static BookshelfMod instance;
    private boolean hasInitialized = false;

    public void init() {
        if (this.hasInitialized) {
            throw new IllegalStateException("The Bookshelf has already been initialized.");
        }
        this.runStartupChecks();
        this.hasInitialized = true;
    }

    private void runStartupChecks() {
        if (Services.PLATFORM == null) {
            throw new IllegalStateException("Bookshelf services are not available.");
        }
        this.detectInvalidContentProviders();
    }

    @Deprecated
    private void detectInvalidContentProviders() {
        try {
            List<String> oldProviders = Services.findServices("net.darkhax.bookshelf.common.api.registry.IContentProvider");
            if (!oldProviders.isEmpty()) {
                String errorMsg = "An outdated implementation of IContentProvider has been found. The game is being stopped for your protection. Please check if an update is available! More information at https://gist.github.com/Darkhax/63356eed0a27848efe8574ce4c677bae";
                Constants.LOG.error("An outdated implementation of IContentProvider has been found. The game is being stopped for your protection. Please check if an update is available! More information at https://gist.github.com/Darkhax/63356eed0a27848efe8574ce4c677bae");
                for (String provider : oldProviders) {
                    Constants.LOG.error("- {}", (Object)provider);
                }
                throw new IllegalStateException("An outdated implementation of IContentProvider has been found. The game is being stopped for your protection. Please check if an update is available! More information at https://gist.github.com/Darkhax/63356eed0a27848efe8574ce4c677bae " + String.join((CharSequence)", ", oldProviders));
            }
        }
        catch (IOException e) {
            Constants.LOG.error("Failed to read services.", (Throwable)e);
        }
    }

    public static BookshelfMod getInstance() {
        if (instance == null) {
            instance = new BookshelfMod();
        }
        return instance;
    }
}

