/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.fabric.impl.util;

import com.google.common.collect.Multimap;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.darkhax.bookshelf.common.api.data.conditions.ILoadCondition;
import net.darkhax.bookshelf.common.api.data.conditions.LoadConditions;
import net.darkhax.bookshelf.common.api.registry.ContentProvider;
import net.darkhax.bookshelf.common.api.registry.RegistrationContext;
import net.darkhax.bookshelf.common.api.registry.adapters.GameRegistryAdapter;
import net.darkhax.bookshelf.common.api.registry.adapters.GenericRegistryAdapter;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.bookshelf.common.impl.Constants;
import net.darkhax.bookshelf.common.impl.registry.adapter.BlockEntityRendererAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.BlockRegistryAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.BlockRenderTypeAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.CommandArgumentAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.CreativeModeTabAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.IngredientTypeAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.LootEntryTypeAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.MenuScreenAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.MenuTypeAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.PacketAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.PotPatternAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.RecipeTypeAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.VillagerTradeAdapter;
import net.darkhax.bookshelf.common.mixin.access.client.AccessorItemBlockRenderTypes;
import net.darkhax.bookshelf.fabric.impl.data.FabricIngredient;
import net.fabricmc.fabric.api.command.v2.ArgumentTypeRegistry;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_1291;
import net.minecraft.class_1320;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_3917;
import net.minecraft.class_3929;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_5338;
import net.minecraft.class_5342;
import net.minecraft.class_5616;
import net.minecraft.class_7375;
import net.minecraft.class_7701;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9766;

public final class FabricRegistryHelper {
    private final ContentProvider content;
    private final RegistrationContext context;

    public FabricRegistryHelper(ContentProvider content) {
        this.content = content;
        this.context = new RegistrationContext(content.namespace());
        if (content.canLoad()) {
            this.registerContent();
            this.registerVillagerTrades();
            this.registerCommands();
            if (Services.PLATFORM.isPhysicalClient()) {
                this.registerClient();
            }
        } else {
            Constants.LOG.debug("Content provider {} is disabled.", (Object)content);
        }
    }

    private void registerContent() {
        this.content.defineLoadConditions(new GenericRegistryAdapter<MapCodec<? extends ILoadCondition>>(this.context, (id, val) -> LoadConditions.register(id, (MapCodec)val.get())));
        this.content.defineBlocks(new BlockRegistryAdapter(this.context, (class_5321<class_2378<class_2248>>)class_7924.field_41254, FabricRegistryHelper.adapt(class_7923.field_41175)));
        this.context.getPlaceableBlocks().forEach((ref, factory) -> class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)((class_5321)ref.key()).method_29177(), (Object)((class_1792)factory.apply((class_2248)ref.value().get()))));
        this.content.defineItems(new GameRegistryAdapter<class_1792>(this.context, class_7924.field_41197, FabricRegistryHelper.adapt(class_7923.field_41178)));
        this.content.defineCreativeTabs(new CreativeModeTabAdapter(this.context, (class_5321<class_2378<class_1761>>)class_7924.field_44688, FabricRegistryHelper.adapt(class_7923.field_44687)));
        this.content.defineIngredientTypes(new IngredientTypeAdapter(this.context, (id, value) -> CustomIngredientSerializer.register((CustomIngredientSerializer)FabricRegistryHelper.adaptType(id, (IngredientTypeAdapter.IngredientType)value.get()))));
        this.content.defineRecipeTypes(new RecipeTypeAdapter(this.context, (class_5321<class_2378<class_3956<?>>>)class_7924.field_41217, FabricRegistryHelper.adapt(class_7923.field_41188)));
        this.content.defineAttributes(new GameRegistryAdapter<class_1320>(this.context, class_7924.field_41251, FabricRegistryHelper.adapt(class_7923.field_41190)));
        this.content.defineMobEffects(new GameRegistryAdapter<class_1291>(this.context, class_7924.field_41208, FabricRegistryHelper.adapt(class_7923.field_41174)));
        this.content.defineCriteriaTriggers(new GameRegistryAdapter(this.context, class_7924.field_47498, FabricRegistryHelper.adapt(class_7923.field_47496)));
        this.content.defineItemSubPredicates(new GameRegistryAdapter(this.context, class_7924.field_49914, FabricRegistryHelper.adapt(class_7923.field_49912)));
        this.content.defineEntities(new GameRegistryAdapter(this.context, class_7924.field_41266, FabricRegistryHelper.adapt(class_7923.field_41177)));
        this.content.defineCatVariants(new GameRegistryAdapter<class_7375>(this.context, class_7924.field_41259, FabricRegistryHelper.adapt(class_7923.field_41163)));
        this.content.definePotions(new GameRegistryAdapter<class_1842>(this.context, class_7924.field_41215, FabricRegistryHelper.adapt(class_7923.field_41179)));
        this.content.definePotPatterns(new PotPatternAdapter(this.context, (class_5321<class_2378<class_9766>>)class_7924.field_42941, FabricRegistryHelper.adapt(class_7923.field_42940)));
        this.content.defineItemComponents(new GameRegistryAdapter(this.context, class_7924.field_49659, FabricRegistryHelper.adapt(class_7923.field_49658)));
        this.content.defineEnchantmentComponents(new GameRegistryAdapter(this.context, class_7924.field_51838, FabricRegistryHelper.adapt(class_7923.field_51832)));
        this.content.defineLootConditions(new GameRegistryAdapter<class_5342>(this.context, class_7924.field_41198, FabricRegistryHelper.adapt(class_7923.field_41135)));
        this.content.defineLootFunctions(new GameRegistryAdapter(this.context, class_7924.field_41199, FabricRegistryHelper.adapt(class_7923.field_41134)));
        this.content.defineBlockEntities(new GameRegistryAdapter(this.context, class_7924.field_41255, FabricRegistryHelper.adapt(class_7923.field_41181)));
        this.content.defineRecipeSerializers(new GameRegistryAdapter(this.context, class_7924.field_41216, FabricRegistryHelper.adapt(class_7923.field_41189)));
        this.content.defineLootEntryTypes(new LootEntryTypeAdapter(this.context, (class_5321<class_2378<class_5338>>)class_7924.field_41202, FabricRegistryHelper.adapt(class_7923.field_41133)));
        this.content.defineMenuType(new MenuTypeAdapter(this.context, (key, factory) -> class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)key, (Object)new class_3917(((MenuTypeAdapter.ClientMenuFactory)factory.get())::create, class_7701.field_40182))));
        this.content.definePackets(new PacketAdapter(this.context, Services.NETWORK::register));
    }

    private void registerClient() {
        this.content.defineMenuScreens(new MenuScreenAdapter((id, factory) -> class_3929.method_17542((class_3917)id, factory::create)));
        Map<class_2248, class_1921> blockRenderTypes = AccessorItemBlockRenderTypes.bookshelf$getBlockTypes();
        this.content.defineBlockRenderTypes(new BlockRenderTypeAdapter(blockRenderTypes::put));
        this.content.defineBlockRenderers(new BlockEntityRendererAdapter(class_5616::method_32144));
    }

    private void registerVillagerTrades() {
        List<class_3853.class_1652> rareTrades;
        VillagerTradeAdapter register = new VillagerTradeAdapter();
        this.content.defineTrades(register);
        for (Map.Entry<class_3852, Multimap<Integer, class_3853.class_1652>> professionData : register.getVillagerTrades().entrySet()) {
            Int2ObjectMap professionTrades = class_3853.field_17067.computeIfAbsent(professionData.getKey(), profession -> new Int2ObjectOpenHashMap());
            Iterator iterator = professionData.getValue().keySet().iterator();
            while (iterator.hasNext()) {
                int merchantTier = (Integer)iterator.next();
                ArrayList<class_3853.class_1652> tradesForTier = new ArrayList<class_3853.class_1652>(Arrays.asList((class_3853.class_1652[])professionTrades.getOrDefault(merchantTier, (Object)new class_3853.class_1652[0])));
                tradesForTier.addAll(professionData.getValue().get((Object)merchantTier));
                professionTrades.put(merchantTier, (Object)tradesForTier.toArray(new class_3853.class_1652[0]));
            }
        }
        List<class_3853.class_1652> commonTrades = register.getCommonWanderingTrades();
        if (!commonTrades.isEmpty()) {
            ArrayList<class_3853.class_1652> tradeData = new ArrayList<class_3853.class_1652>(Arrays.asList((class_3853.class_1652[])class_3853.field_17724.get(1)));
            tradeData.addAll(commonTrades);
            class_3853.field_17724.put(1, (Object)tradeData.toArray(new class_3853.class_1652[0]));
        }
        if (!(rareTrades = register.getRareWanderingTrades()).isEmpty()) {
            ArrayList<class_3853.class_1652> tradeData = new ArrayList<class_3853.class_1652>(Arrays.asList((class_3853.class_1652[])class_3853.field_17724.get(2)));
            tradeData.addAll(rareTrades);
            class_3853.field_17724.put(2, (Object)tradeData.toArray(new class_3853.class_1652[0]));
        }
    }

    private void registerCommands() {
        CommandRegistrationCallback.EVENT.register(this.content::defineCommands);
        this.content.defineCommandArguments(new CommandArgumentAdapter(this.context, (rl, info) -> FabricRegistryHelper.registerCommandArgument(rl, (CommandArgumentAdapter.TypeInfo)info.get())));
    }

    private static void registerCommandArgument(class_2960 key, CommandArgumentAdapter.TypeInfo type) {
        ArgumentTypeRegistry.registerArgumentType((class_2960)key, type.argType(), type.typeIfo());
    }

    private static CustomIngredientSerializer adaptType(class_2960 id, IngredientTypeAdapter.IngredientType type) {
        return FabricIngredient.make(id, type.codec(), type.stream());
    }

    private static <T> BiConsumer<class_5321<T>, Supplier<T>> adapt(class_2378<T> registry) {
        return (key, value) -> class_2378.method_39197((class_2378)registry, (class_5321)key, value.get());
    }
}

