/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.api.function;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.darkhax.bookshelf.common.impl.Constants;
import net.darkhax.bookshelf.common.mixin.access.level.AccessorRecipeManager;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

public class ReloadableCache<T>
implements Function<class_1937, T> {
    public static final ReloadableCache EMPTY = ReloadableCache.of((class_1937 level) -> null);
    private final Function<class_1937, T> delegate;
    private boolean cached = false;
    private int revision = 0;
    @Nullable
    private T cachedValue;

    protected ReloadableCache(Function<class_1937, T> delegate) {
        this.delegate = delegate;
    }

    @Override
    @Nullable
    public T apply(class_1937 level) {
        if (!this.isCached() || this.revision != (level.field_9236 ? Constants.CLIENT_REVISION : Constants.SERVER_REVISION)) {
            this.cachedValue = this.delegate.apply(level);
            this.revision = level.field_9236 ? Constants.CLIENT_REVISION : Constants.SERVER_REVISION;
            this.cached = true;
        }
        return this.cachedValue;
    }

    public void invalidate() {
        this.cached = false;
        this.cachedValue = null;
        this.revision = -1;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void apply(class_1937 level, Consumer<T> consumer) {
        consumer.accept(this.apply(level));
    }

    public void ifPresent(class_1937 level, Consumer<T> consumer) {
        T value = this.apply(level);
        if (value != null) {
            consumer.accept(value);
        }
    }

    @Nullable
    public <R> R map(class_1937 level, Function<T, R> mapper) {
        T value = this.apply(level);
        return value != null ? (R)mapper.apply(value) : null;
    }

    public static <T> ReloadableCache<T> of(Supplier<T> supplier) {
        return new ReloadableCache<Object>(level -> supplier.get());
    }

    public static <T> ReloadableCache<T> of(Function<class_1937, T> delegate) {
        return new ReloadableCache<T>(delegate);
    }

    public static <T> ReloadableCache<T> of(class_5321<? extends class_2378<T>> registry, class_2960 id) {
        return ReloadableCache.of((class_1937 level) -> level.method_30349().method_30530(registry).method_10223(id));
    }

    public static <T extends class_1860<?>> ReloadableCache<Map<class_2960, class_8786<T>>> of(class_3956<T> type) {
        return ReloadableCache.of((class_1937 level) -> {
            HashMap byId = new HashMap();
            class_1863 patt0$temp = level.method_8433();
            if (patt0$temp instanceof AccessorRecipeManager) {
                AccessorRecipeManager accessor = (AccessorRecipeManager)patt0$temp;
                Collection recipes = accessor.bookshelf$byTypeMap().get((Object)type);
                recipes.forEach(entry -> byId.put(entry.comp_1932(), entry));
            }
            return byId;
        });
    }

    public static <T extends class_1860<?>> ReloadableCache<Map<class_2960, class_8786<T>>> recipes(Supplier<class_3956<T>> type) {
        return ReloadableCache.of((class_1937 level) -> {
            HashMap byId = new HashMap();
            class_1863 patt0$temp = level.method_8433();
            if (patt0$temp instanceof AccessorRecipeManager) {
                AccessorRecipeManager accessor = (AccessorRecipeManager)patt0$temp;
                Collection recipes = accessor.bookshelf$byTypeMap().get((Object)((class_3956)type.get()));
                recipes.forEach(entry -> byId.put(entry.comp_1932(), entry));
            }
            return byId;
        });
    }

    public static ReloadableCache<class_1297> entity(class_2487 entityData) {
        if (entityData == null || !entityData.method_10573("id", 8)) {
            throw new IllegalStateException("The provided entity data does not contain an entity ID! data=" + String.valueOf(entityData));
        }
        return ReloadableCache.of((class_1937 level) -> {
            try {
                return class_1299.method_17842((class_2487)entityData, (class_1937)level, Function.identity());
            }
            catch (Exception e) {
                throw new IllegalStateException("Encountered an error while constructing the target entity.", e);
            }
        });
    }

    public static ReloadableCache<class_1309> living(class_2487 entityData) {
        ReloadableCache<class_1297> entityCache = ReloadableCache.entity(entityData);
        return ReloadableCache.of((class_1937 level) -> {
            Object patt0$temp = entityCache.apply((class_1937)level);
            if (patt0$temp instanceof class_1309) {
                class_1309 living = (class_1309)patt0$temp;
                return living;
            }
            throw new IllegalStateException("Constructed entity was not a LivingEntity type. data=" + String.valueOf(entityData));
        });
    }
}

