/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.api.registry;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.darkhax.bookshelf.common.api.registry.RegistryReference;
import net.darkhax.bookshelf.common.impl.Constants;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_9766;

public final class RegistrationContext {
    private final String namespace;
    private final Map<RegistryReference<class_5321<class_2248>, class_2248>, Function<class_2248, class_1792>> placeableBlocks = new HashMap<RegistryReference<class_5321<class_2248>, class_2248>, Function<class_2248, class_1792>>();
    private static final Map<class_1792, class_5321<class_9766>> INTERNAL_POT_PATTERN_ITEMS = new HashMap<class_1792, class_5321<class_9766>>();
    public static final Map<class_1792, class_5321<class_9766>> POT_PATTERN_ITEMS = Collections.unmodifiableMap(INTERNAL_POT_PATTERN_ITEMS);

    public RegistrationContext(String namespace) {
        this.namespace = namespace;
    }

    public String namespace() {
        return this.namespace;
    }

    public void addPlaceableBlock(RegistryReference<class_5321<class_2248>, class_2248> block, Function<class_2248, class_1792> itemBlock) {
        this.placeableBlocks.put(block, itemBlock);
    }

    public Map<RegistryReference<class_5321<class_2248>, class_2248>, Function<class_2248, class_1792>> getPlaceableBlocks() {
        return Collections.unmodifiableMap(this.placeableBlocks);
    }

    public void addPotPatternItem(class_1792 item, class_5321<class_9766> pattern) {
        if (INTERNAL_POT_PATTERN_ITEMS.containsKey(item)) {
            Constants.LOG.warn("Mod {} has changed the pot pattern of {} to {} from {}.", new Object[]{this.namespace(), class_7923.field_41178.method_10221((Object)item), pattern.method_29177(), INTERNAL_POT_PATTERN_ITEMS.get(item).method_29177()});
        }
        INTERNAL_POT_PATTERN_ITEMS.put(item, pattern);
    }
}

