/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.api.function;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.darkhax.bookshelf.common.impl.Constants;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class CachedSupplier<T>
implements Supplier<T> {
    private final Supplier<T> delegate;
    private boolean cached = false;
    @Nullable
    private T cachedValue;

    protected CachedSupplier(Supplier<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public T get() {
        if (!this.isCached()) {
            this.cachedValue = this.delegate.get();
            this.cached = true;
        }
        return this.cachedValue;
    }

    public void invalidate() {
        this.cached = false;
        this.cachedValue = null;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void ifCached(Consumer<T> consumer) {
        if (this.isCached()) {
            consumer.accept(this.get());
        }
    }

    public void ifPresent(Consumer<T> consumer) {
        if (this.cachedValue != null) {
            consumer.accept(this.get());
        }
    }

    public void apply(Consumer<T> consumer) {
        consumer.accept(this.get());
    }

    public <X> CachedSupplier<X> cast() {
        return this;
    }

    public static <T> CachedSupplier<T> singleton(T singleton) {
        return CachedSupplier.cache(() -> singleton);
    }

    public static <T> CachedSupplier<T> cache(Supplier<T> delegate) {
        return new CachedSupplier<T>(delegate);
    }

    public static <T> CachedSupplier<T> of(class_5321<T> key) {
        return CachedSupplier.cache(() -> {
            class_2378 registry = (class_2378)class_7923.field_41167.method_10223(key.method_41185());
            if (registry == null) {
                Constants.LOG.error("Registry {} could not be found!", (Object)key.method_41185());
                throw new IllegalStateException("Registry with name " + String.valueOf(key.method_41185()) + " was not found!");
            }
            return registry.method_31140(key);
        });
    }

    public static <T> CachedSupplier<T> of(class_2378<T> registry, String namespace, String path) {
        return CachedSupplier.of(registry, class_2960.method_60655((String)namespace, (String)path));
    }

    public static <T> CachedSupplier<T> of(class_2378<T> registry, class_2960 id) {
        return CachedSupplier.cache(() -> registry.method_10223(id));
    }
}

