/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.impl.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.darkhax.bookshelf.common.api.commands.PermissionLevel;
import net.darkhax.bookshelf.common.api.commands.args.FontArgument;
import net.darkhax.bookshelf.common.api.util.CommandHelper;
import net.darkhax.bookshelf.common.api.util.TextHelper;
import net.darkhax.bookshelf.common.mixin.access.block.AccessorBannerBlockEntity;
import net.darkhax.bookshelf.common.mixin.access.block.AccessorBaseContainerBlockEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2196;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2573;
import net.minecraft.class_2586;
import net.minecraft.class_2624;
import net.minecraft.class_2625;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.minecraft.class_8242;
import net.minecraft.class_9334;

public class FontCommand {
    public static LiteralArgumentBuilder<class_2168> build() {
        LiteralArgumentBuilder font = (LiteralArgumentBuilder)class_2170.method_9247((String)"font").requires((Predicate)PermissionLevel.GAMEMASTER);
        LiteralArgumentBuilder rename = class_2170.method_9247((String)"rename");
        rename.then(FontArgument.argument().executes(FontCommand::renameItemWithFont));
        rename.then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9309()).then(FontArgument.argument().executes(FontCommand::renameItemWithFont)));
        font.then((ArgumentBuilder)rename);
        font.then(class_2170.method_9247((String)"block").then(FontArgument.argument().then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(FontCommand::renameBlockWithFont))));
        font.then(class_2170.method_9247((String)"say").then(FontArgument.argument().then(class_2170.method_9244((String)"message", (ArgumentType)class_2196.method_9340()).executes(FontCommand::speakWithFont))));
        return font;
    }

    private static int speakWithFont(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2960 fontId = FontArgument.get(context);
        class_2561 inputMessage = TextHelper.applyFont(class_2196.method_9339(context, (String)"message"), fontId);
        class_5250 txtMessage = class_2561.method_43469((String)"chat.type.announcement", (Object[])new Object[]{((class_2168)context.getSource()).method_9223(), inputMessage});
        ((class_2168)context.getSource()).method_9211().method_3760().method_43514((class_2561)txtMessage, false);
        return 0;
    }

    private static int renameItemWithFont(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2960 fontId = FontArgument.get(context);
        class_1297 target = CommandHelper.getEntityOrSender("target", context);
        if (target instanceof class_1309) {
            class_1309 living = (class_1309)target;
            class_1799 stack = living.method_6047();
            if (stack.method_7960()) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.bookshelf.hand.error.not_air"));
                return 0;
            }
            stack.method_57379(class_9334.field_49631, (Object)TextHelper.applyFont((class_2561)stack.method_7964().method_27661(), fontId));
            return 1;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.bookshelf.font.bad_sender"));
        return 0;
    }

    private static int renameBlockWithFont(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3218 world = ((class_2168)context.getSource()).method_9225();
        class_2960 fontId = FontArgument.get(context);
        class_2338 pos = class_2262.method_9696(context, (String)"pos");
        class_2586 tile = world.method_8321(pos);
        if (tile != null && tile.method_11002()) {
            class_2586 class_25862 = tile;
            Objects.requireNonNull(class_25862);
            class_2586 class_25863 = class_25862;
            int n = 0;
            block5: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_2624.class, class_2625.class, class_2573.class}, (Object)class_25863, n)) {
                    case 0: {
                        class_2624 container = (class_2624)class_25863;
                        if (!(tile instanceof AccessorBaseContainerBlockEntity)) {
                            n = 1;
                            continue block5;
                        }
                        AccessorBaseContainerBlockEntity accessor = (AccessorBaseContainerBlockEntity)tile;
                        accessor.bookshelf$name(TextHelper.applyFont((class_2561)container.method_5477().method_27661(), fontId));
                        break block5;
                    }
                    case 1: {
                        class_2625 sign = (class_2625)class_25863;
                        if (sign.method_10997() == null) break block5;
                        sign.method_49841(FontCommand.applySignFont(fontId), true);
                        sign.method_49841(FontCommand.applySignFont(fontId), false);
                        sign.method_10997().method_8413(sign.method_11016(), sign.method_11010(), sign.method_11010(), 3);
                        break block5;
                    }
                    case 2: {
                        class_2573 banner = (class_2573)class_25863;
                        if (!banner.method_16914() || !(banner instanceof AccessorBannerBlockEntity)) {
                            n = 3;
                            continue block5;
                        }
                        AccessorBannerBlockEntity accessor = (AccessorBannerBlockEntity)banner;
                        accessor.setName(TextHelper.applyFont(banner.method_5797(), fontId));
                        break block5;
                    }
                    default: {
                        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"commands.bookshelf.font.unsupported_block", (Object[])new Object[]{tile.method_11010().method_26204().method_9518()}));
                        break block5;
                    }
                }
                break;
            }
        }
        return 1;
    }

    private static UnaryOperator<class_8242> applySignFont(class_2960 fontId) {
        return text -> {
            class_8242 newText = text;
            for (int i = 0; i < 4; ++i) {
                newText = newText.method_49857(i, TextHelper.applyFont((class_2561)text.method_49859(i, false).method_27661(), fontId));
            }
            return newText;
        };
    }
}

