/*
 * Decompiled with CFR 0.152.
 */
package com.nightbeam.core_utilities.block;

import com.nightbeam.core_utilities.block.entity.CableLBlockEntity;
import com.nightbeam.core_utilities.init.CoreUtilitiesModBlocks;
import com.nightbeam.core_utilities.procedures.CableUpdateTickProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CableLBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = DirectionalBlock.FACING;

    public CableLBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).sound(SoundType.WOOL).strength(2.5f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)CableLBlock.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)16.0), (VoxelShape)CableLBlock.box((double)0.0, (double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0));
            case Direction.NORTH -> Shapes.or((VoxelShape)CableLBlock.box((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)11.0), (VoxelShape)CableLBlock.box((double)11.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0));
            case Direction.EAST -> Shapes.or((VoxelShape)CableLBlock.box((double)5.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0), (VoxelShape)CableLBlock.box((double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0, (double)16.0));
            case Direction.WEST -> Shapes.or((VoxelShape)CableLBlock.box((double)0.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0), (VoxelShape)CableLBlock.box((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)5.0));
            case Direction.UP -> Shapes.or((VoxelShape)CableLBlock.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), (VoxelShape)CableLBlock.box((double)11.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0));
            case Direction.DOWN -> Shapes.or((VoxelShape)CableLBlock.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0), (VoxelShape)CableLBlock.box((double)11.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0));
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getNearestLookingDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)CoreUtilitiesModBlocks.CABLE.get());
    }

    public void onPlace(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(blockstate, world, pos, oldState, moving);
        world.scheduleTick(pos, (Block)this, 1);
    }

    public void tick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        super.tick(blockstate, world, pos, random);
        CableUpdateTickProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
        world.scheduleTick(pos, (Block)this, 1);
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CableLBlockEntity(pos, state);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity != null && blockEntity.triggerEvent(eventID, eventParam);
    }
}

