/*
 * Decompiled with CFR 0.152.
 */
package com.nightbeam.core_utilities.init;

import com.nightbeam.core_utilities.CoreUtilitiesMod;
import com.nightbeam.core_utilities.init.CoreUtilitiesModScreens;
import com.nightbeam.core_utilities.network.MenuStateUpdateMessage;
import com.nightbeam.core_utilities.world.inventory.BigBackpackGUIMenu;
import com.nightbeam.core_utilities.world.inventory.MediumBackpackGUIMenu;
import com.nightbeam.core_utilities.world.inventory.SmallBackpackGUIMenu;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class CoreUtilitiesModMenus {
    public static final DeferredRegister<MenuType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"core_utilities");
    public static final RegistryObject<MenuType<SmallBackpackGUIMenu>> SMALL_BACKPACK_GUI = REGISTRY.register("small_backpack_gui", () -> IForgeMenuType.create(SmallBackpackGUIMenu::new));
    public static final RegistryObject<MenuType<BigBackpackGUIMenu>> BIG_BACKPACK_GUI = REGISTRY.register("big_backpack_gui", () -> IForgeMenuType.create(BigBackpackGUIMenu::new));
    public static final RegistryObject<MenuType<MediumBackpackGUIMenu>> MEDIUM_BACKPACK_GUI = REGISTRY.register("medium_backpack_gui", () -> IForgeMenuType.create(MediumBackpackGUIMenu::new));

    public static interface MenuAccessor {
        public Map<String, Object> getMenuState();

        public Map<Integer, Slot> getSlots();

        default public void sendMenuStateUpdate(Player player, int elementType, String name, Object elementState, boolean needClientUpdate) {
            this.getMenuState().put(elementType + ":" + name, elementState);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CoreUtilitiesMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MenuStateUpdateMessage(elementType, name, elementState));
            } else if (player.f_19853_.f_46443_) {
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen instanceof CoreUtilitiesModScreens.ScreenAccessor) {
                    CoreUtilitiesModScreens.ScreenAccessor accessor = (CoreUtilitiesModScreens.ScreenAccessor)screen;
                    if (needClientUpdate) {
                        accessor.updateMenuState(elementType, name, elementState);
                    }
                }
                CoreUtilitiesMod.PACKET_HANDLER.sendToServer((Object)new MenuStateUpdateMessage(elementType, name, elementState));
            }
        }

        default public <T> T getMenuState(int elementType, String name, T defaultValue) {
            try {
                return (T)this.getMenuState().getOrDefault(elementType + ":" + name, defaultValue);
            }
            catch (ClassCastException e) {
                return defaultValue;
            }
        }
    }
}

