/*
 * Decompiled with CFR 0.152.
 */
package com.nightbeam.core_utilities.item.inventory;

import com.nightbeam.core_utilities.init.CoreUtilitiesModItems;
import com.nightbeam.core_utilities.world.inventory.BigBackpackGUIMenu;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemStackHandler;

@Mod.EventBusSubscriber
public class BigBackpackInventoryCapability
implements ICapabilitySerializable<CompoundTag> {
    private final LazyOptional<ItemStackHandler> inventory = LazyOptional.of(this::createItemHandler);

    @SubscribeEvent
    public static void onItemDropped(ItemTossEvent event) {
        if (event.getEntity().m_32055_().m_41720_() == CoreUtilitiesModItems.BIG_BACKPACK.get()) {
            Player player = event.getPlayer();
            if (player.f_36096_ instanceof BigBackpackGUIMenu) {
                player.m_6915_();
            }
        }
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        return capability == ForgeCapabilities.ITEM_HANDLER ? this.inventory.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return this.getItemHandler().serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.getItemHandler().deserializeNBT(nbt);
    }

    private ItemStackHandler createItemHandler() {
        return new ItemStackHandler(100){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.m_41720_() != CoreUtilitiesModItems.BIG_BACKPACK.get();
            }

            public void setSize(int size) {
            }
        };
    }

    private ItemStackHandler getItemHandler() {
        return (ItemStackHandler)this.inventory.orElseThrow(RuntimeException::new);
    }
}

