/*
 * Decompiled with CFR 0.152.
 */
package com.nightbeam.core_utilities.procedures;

import com.nightbeam.core_utilities.init.CoreUtilitiesModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class SolarPanelUpdateTickProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z) {
        double send = 0.0;
        double sendPosition = 0.0;
        double maxSend = 0.0;
        BlockState lowLevelBlock = Blocks.AIR.defaultBlockState();
        BlockState mediumLevelBlock = Blocks.AIR.defaultBlockState();
        BlockState highLevelBlock = Blocks.AIR.defaultBlockState();
        if (!world.isClientSide()) {
            sendPosition = y - 1.0;
            maxSend = 64.0;
            lowLevelBlock = ((Block)CoreUtilitiesModBlocks.SOLAR_PANEL_2.get()).defaultBlockState();
            mediumLevelBlock = ((Block)CoreUtilitiesModBlocks.SOLAR_PANEL_1.get()).defaultBlockState();
            highLevelBlock = ((Block)CoreUtilitiesModBlocks.SOLAR_PANEL.get()).defaultBlockState();
            if (SolarPanelUpdateTickProcedure.canReceiveEnergy(world, BlockPos.containing((double)x, (double)sendPosition, (double)z), Direction.UP) && SolarPanelUpdateTickProcedure.getBlockNBTLogic(world, BlockPos.containing((double)x, (double)sendPosition, (double)z), "cablesFCopperUp")) {
                Level _lvl20;
                Level _lvl14;
                Level _lvl6;
                if (!world.isClientSide()) {
                    BlockPos _bp = BlockPos.containing((double)x, (double)sendPosition, (double)z);
                    BlockEntity _blockEntity = world.getBlockEntity(_bp);
                    BlockState _bs = world.getBlockState(_bp);
                    if (_blockEntity != null) {
                        _blockEntity.getPersistentData().putDouble("forgeFlow", 1024.0);
                    }
                    if (world instanceof Level) {
                        Level _level = (Level)world;
                        _level.sendBlockUpdated(_bp, _bs, _bs, 3);
                    }
                }
                if (world.getLevelData().isRaining() && world.getLevelData().isThundering() && world instanceof Level && (_lvl6 = (Level)world).isBrightOutside()) {
                    IEnergyStorage _entityStorage;
                    _bp = BlockPos.containing((double)x, (double)y, (double)z);
                    BlockState _bs = lowLevelBlock;
                    BlockState _bso = world.getBlockState(_bp);
                    for (Property _propertyOld : _bso.getProperties()) {
                        Property _propertyNew = _bs.getBlock().getStateDefinition().getProperty(_propertyOld.getName());
                        if (_propertyNew == null || _bs.getValue(_propertyNew) == null) continue;
                        try {
                            _bs = (BlockState)_bs.setValue(_propertyNew, _bso.getValue(_propertyOld));
                        }
                        catch (Exception exception) {}
                    }
                    BlockEntity _be = world.getBlockEntity(_bp);
                    CompoundTag _bnbt = null;
                    if (_be != null) {
                        _bnbt = _be.saveWithFullMetadata((HolderLookup.Provider)world.registryAccess());
                        _be.setRemoved();
                    }
                    world.setBlock(_bp, _bs, 3);
                    if (_bnbt != null && (_be = world.getBlockEntity(_bp)) != null) {
                        try {
                            _be.loadWithComponents(_bnbt, (HolderLookup.Provider)world.registryAccess());
                        }
                        catch (Exception _propertyNew) {
                            // empty catch block
                        }
                    }
                    send = SolarPanelUpdateTickProcedure.receiveEnergySimulate(world, BlockPos.containing((double)x, (double)sendPosition, (double)z), (int)(maxSend / 4.0), Direction.UP);
                    if (world instanceof ILevelExtension && (_entityStorage = (IEnergyStorage)(_ext = (ILevelExtension)world).getCapability(Capabilities.EnergyStorage.BLOCK, BlockPos.containing((double)x, (double)sendPosition, (double)z), (Object)Direction.UP)) != null) {
                        _entityStorage.receiveEnergy((int)send, false);
                    }
                } else if ((!world.getLevelData().isRaining() && world.getLevelData().isThundering() || world.getLevelData().isRaining() && !world.getLevelData().isThundering()) && world instanceof Level && (_lvl14 = (Level)world).isBrightOutside()) {
                    IEnergyStorage _entityStorage;
                    _bp = BlockPos.containing((double)x, (double)y, (double)z);
                    BlockState _bs = mediumLevelBlock;
                    BlockState _bso = world.getBlockState(_bp);
                    for (Property _propertyOld : _bso.getProperties()) {
                        Property _propertyNew = _bs.getBlock().getStateDefinition().getProperty(_propertyOld.getName());
                        if (_propertyNew == null || _bs.getValue(_propertyNew) == null) continue;
                        try {
                            _bs = (BlockState)_bs.setValue(_propertyNew, _bso.getValue(_propertyOld));
                        }
                        catch (Exception exception) {}
                    }
                    BlockEntity _be = world.getBlockEntity(_bp);
                    CompoundTag _bnbt = null;
                    if (_be != null) {
                        _bnbt = _be.saveWithFullMetadata((HolderLookup.Provider)world.registryAccess());
                        _be.setRemoved();
                    }
                    world.setBlock(_bp, _bs, 3);
                    if (_bnbt != null && (_be = world.getBlockEntity(_bp)) != null) {
                        try {
                            _be.loadWithComponents(_bnbt, (HolderLookup.Provider)world.registryAccess());
                        }
                        catch (Exception _propertyNew) {
                            // empty catch block
                        }
                    }
                    send = SolarPanelUpdateTickProcedure.receiveEnergySimulate(world, BlockPos.containing((double)x, (double)sendPosition, (double)z), (int)(maxSend / 2.0), Direction.UP);
                    if (world instanceof ILevelExtension && (_entityStorage = (IEnergyStorage)(_ext = (ILevelExtension)world).getCapability(Capabilities.EnergyStorage.BLOCK, BlockPos.containing((double)x, (double)sendPosition, (double)z), (Object)Direction.UP)) != null) {
                        _entityStorage.receiveEnergy((int)send, false);
                    }
                } else if (!world.getLevelData().isRaining() && !world.getLevelData().isThundering() && world instanceof Level && (_lvl20 = (Level)world).isBrightOutside()) {
                    IEnergyStorage _entityStorage;
                    _bp = BlockPos.containing((double)x, (double)y, (double)z);
                    BlockState _bs = highLevelBlock;
                    BlockState _bso = world.getBlockState(_bp);
                    for (Property _propertyOld : _bso.getProperties()) {
                        Property _propertyNew = _bs.getBlock().getStateDefinition().getProperty(_propertyOld.getName());
                        if (_propertyNew == null || _bs.getValue(_propertyNew) == null) continue;
                        try {
                            _bs = (BlockState)_bs.setValue(_propertyNew, _bso.getValue(_propertyOld));
                        }
                        catch (Exception exception) {}
                    }
                    BlockEntity _be = world.getBlockEntity(_bp);
                    CompoundTag _bnbt = null;
                    if (_be != null) {
                        _bnbt = _be.saveWithFullMetadata((HolderLookup.Provider)world.registryAccess());
                        _be.setRemoved();
                    }
                    world.setBlock(_bp, _bs, 3);
                    if (_bnbt != null && (_be = world.getBlockEntity(_bp)) != null) {
                        try {
                            _be.loadWithComponents(_bnbt, (HolderLookup.Provider)world.registryAccess());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    send = SolarPanelUpdateTickProcedure.receiveEnergySimulate(world, BlockPos.containing((double)x, (double)sendPosition, (double)z), (int)maxSend, Direction.UP);
                    if (world instanceof ILevelExtension && (_entityStorage = (IEnergyStorage)(_ext = (ILevelExtension)world).getCapability(Capabilities.EnergyStorage.BLOCK, BlockPos.containing((double)x, (double)sendPosition, (double)z), (Object)Direction.UP)) != null) {
                        _entityStorage.receiveEnergy((int)send, false);
                    }
                }
            }
        }
    }

    private static boolean canReceiveEnergy(LevelAccessor level, BlockPos pos, Direction direction) {
        ILevelExtension levelExtension;
        IEnergyStorage energyStorage;
        if (level instanceof ILevelExtension && (energyStorage = (IEnergyStorage)(levelExtension = (ILevelExtension)level).getCapability(Capabilities.EnergyStorage.BLOCK, pos, (Object)direction)) != null) {
            return energyStorage.canReceive();
        }
        return false;
    }

    private static boolean getBlockNBTLogic(LevelAccessor world, BlockPos pos, String tag) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity != null) {
            return blockEntity.getPersistentData().getBooleanOr(tag, false);
        }
        return false;
    }

    private static int receiveEnergySimulate(LevelAccessor level, BlockPos pos, int amount, Direction direction) {
        ILevelExtension levelExtension;
        IEnergyStorage energyStorage;
        if (level instanceof ILevelExtension && (energyStorage = (IEnergyStorage)(levelExtension = (ILevelExtension)level).getCapability(Capabilities.EnergyStorage.BLOCK, pos, (Object)direction)) != null) {
            return energyStorage.receiveEnergy(amount, true);
        }
        return 0;
    }
}

