/*
 * Decompiled with CFR 0.152.
 */
package com.nightbeam.core_utilities.procedures;

import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class VectorPlateWalksOnTheBlockProcedure {
    public static void execute(BlockState blockstate, Entity entity, double power) {
        if (entity == null) {
            return;
        }
        if (!entity.isShiftKeyDown()) {
            if (VectorPlateWalksOnTheBlockProcedure.getDirectionFromBlockState(blockstate) == Direction.NORTH) {
                entity.push(0.0, 0.0, power * 1.0);
            } else if (VectorPlateWalksOnTheBlockProcedure.getDirectionFromBlockState(blockstate) == Direction.EAST) {
                entity.push(power * -1.0, 0.0, 0.0);
            } else if (VectorPlateWalksOnTheBlockProcedure.getDirectionFromBlockState(blockstate) == Direction.SOUTH) {
                entity.push(0.0, 0.0, power * -1.0);
            } else {
                entity.push(power * 1.0, 0.0, 0.0);
            }
        }
    }

    private static Direction getDirectionFromBlockState(BlockState blockState) {
        EnumProperty ep;
        Property property = blockState.getBlock().getStateDefinition().getProperty("facing");
        if (property instanceof EnumProperty && (ep = (EnumProperty)property).getValueClass() == Direction.class) {
            return (Direction)blockState.getValue((Property)ep);
        }
        property = blockState.getBlock().getStateDefinition().getProperty("axis");
        if (property instanceof EnumProperty && (ep = (EnumProperty)property).getValueClass() == Direction.Axis.class) {
            return Direction.fromAxisAndDirection((Direction.Axis)((Direction.Axis)blockState.getValue((Property)ep)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        }
        return Direction.NORTH;
    }
}

