/*
 * Decompiled with CFR 0.152.
 */
package ru.sculmix.playerprofile;

import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import ru.sculmix.playerprofile.INMSHandler;
import ru.sculmix.playerprofile.bstats.Metrics;
import ru.sculmix.playerprofile.commands.Command;
import ru.sculmix.playerprofile.data.PlayerData;
import ru.sculmix.playerprofile.database.DatabaseType;
import ru.sculmix.playerprofile.database.MySQL;
import ru.sculmix.playerprofile.database.SQL;
import ru.sculmix.playerprofile.database.SQLite;
import ru.sculmix.playerprofile.files.FileCreator;
import ru.sculmix.playerprofile.files.FileMenus;
import ru.sculmix.playerprofile.inventories.MenuLoader;
import ru.sculmix.playerprofile.listeners.InventoryListener;
import ru.sculmix.playerprofile.listeners.ItemsAdderListener;
import ru.sculmix.playerprofile.listeners.JoinListener;
import ru.sculmix.playerprofile.listeners.NexoListener;
import ru.sculmix.playerprofile.listeners.PlayerInteractListener;
import ru.sculmix.playerprofile.listeners.QuitListener;
import ru.sculmix.playerprofile.listeners.ServerLoadedListener;
import ru.sculmix.playerprofile.nms.v1_17_R1.NMSHandler_v1_17_R1;
import ru.sculmix.playerprofile.nms.v1_18_R1.NMSHandler_v1_18_R1;
import ru.sculmix.playerprofile.nms.v1_18_R2.NMSHandler_v1_18_R2;
import ru.sculmix.playerprofile.nms.v1_19_R1.NMSHandler_v1_19_R1;
import ru.sculmix.playerprofile.nms.v1_19_R2.network.NMSHandler_v1_19_R2;
import ru.sculmix.playerprofile.nms.v1_19_R3.NMSHandler_v1_19_R3;
import ru.sculmix.playerprofile.nms.v1_20_R1.NMSHandler_v1_20_R1;
import ru.sculmix.playerprofile.nms.v1_20_R2.NMSHandler_v1_20_R2;
import ru.sculmix.playerprofile.nms.v1_20_R3.NMSHandler_v1_20_R3;
import ru.sculmix.playerprofile.nms.v1_20_R4.NMSHandler_v1_20_R4;
import ru.sculmix.playerprofile.nms.v1_21_R1.NMSHandler_v1_21_R1;
import ru.sculmix.playerprofile.nms.v1_21_R2.NMSHandler_v1_21_R2;
import ru.sculmix.playerprofile.nms.v1_21_R3.NMSHandler_v1_21_R3;
import ru.sculmix.playerprofile.nms.v1_21_R4.NMSHandler_v1_21_R4;
import ru.sculmix.playerprofile.nms.v1_21_R5.NMSHandler_v1_21_R5;
import ru.sculmix.playerprofile.providers.ECosmetics;
import ru.sculmix.playerprofile.providers.ItemsAdder;
import ru.sculmix.playerprofile.providers.Nexo;
import ru.sculmix.playerprofile.providers.PlaceholderAPI;
import ru.sculmix.playerprofile.utils.Utils;

public final class PlayerProfile
extends JavaPlugin {
    private static PlayerProfile instance;
    private SQL sql;
    private FileCreator config;
    private FileCreator status;
    private FileCreator titleMenus;
    private PlaceholderAPI placeholderAPI;
    private ItemsAdder itemsAdder;
    private MenuLoader menuLoader;
    private ECosmetics ECosmetics;
    private boolean offlinePlayers;
    private Nexo nexo;
    private FileMenus menus;
    private boolean shiftOpenProfile;
    private String defaultStatus;
    private INMSHandler nmsHandler;

    public void onEnable() {
        int pluginId = 26930;
        Metrics metrics = new Metrics((Plugin)this, pluginId);
        instance = this;
        this.config = new FileCreator((Plugin)this, "config");
        this.status = new FileCreator((Plugin)this, "status");
        this.loadNewMessages();
        if (this.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            this.setPlaceholderAPI(new PlaceholderAPI());
        }
        if (!this.loadNMS()) {
            return;
        }
        this.menus = new FileMenus();
        this.setupDatabase();
        if (this.getServer().getPluginManager().getPlugin("ItemsAdder") != null) {
            this.setItemsAdder(new ItemsAdder());
        }
        this.registerListeners();
        this.registerCommands();
        for (Player player : this.getServer().getOnlinePlayers()) {
            PlayerData.getPlayer(player);
        }
        this.offlinePlayers = this.getConfig().getBoolean("offline-players");
        this.defaultStatus = this.status.getString("default-status");
        if (this.existItemsAdder()) {
            return;
        }
        if (!this.offlinePlayers) {
            return;
        }
        this.sql.loadPlayersAsync();
        this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
            this.getLogger().info("Performing delayed initialization...");
            if (this.getServer().getPluginManager().isPluginEnabled("ItemsAdder")) {
                this.setItemsAdder(new ItemsAdder());
            }
            if (this.getServer().getPluginManager().isPluginEnabled("ECosmetics")) {
                this.setECosmetics(new ECosmetics());
            }
            if (this.getServer().getPluginManager().isPluginEnabled("Nexo")) {
                this.setNexo(new Nexo());
            }
            this.menus = new FileMenus();
            this.menuLoader = new MenuLoader();
            this.setupDatabase();
            if (!this.existItemsAdder() && this.getConfig().getBoolean("offline-players")) {
                this.sql.loadPlayersAsync();
            }
            this.offlinePlayers = this.getConfig().getBoolean("offline-players");
            this.defaultStatus = this.status.getString("default-status");
            for (Player player : this.getServer().getOnlinePlayers()) {
                PlayerData.getPlayer(player);
            }
            this.getLogger().info("Delayed initialization complete!");
        }, 1L);
    }

    private void setupDatabase() {
        if (!this.config.contains("database")) {
            this.config.set("database.type", "sqlite");
            this.config.set("database.host", "127.0.0.1");
            this.config.set("database.port", "3306");
            this.config.set("database.user", "root");
            this.config.set("database.password", "password");
            this.config.set("database.table", "players");
            this.config.set("database.database_name", "playerprofile");
            this.config.save();
            this.sql = new SQLite();
            return;
        }
        String type = this.config.getString("database.type");
        try {
            DatabaseType databaseType = DatabaseType.valueOf(type.toUpperCase());
            switch (databaseType) {
                case SQLITE: {
                    this.sql = new SQLite();
                    break;
                }
                case MYSQL: {
                    this.sql = new MySQL();
                    break;
                }
                default: {
                    this.getLogger().warning("No database of type '" + type + "' has been detected.");
                    break;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private boolean loadNMS() {
        this.getLogger().info("Detected server version: " + Utils.getVersion());
        switch (Utils.getVersion()) {
            case "1.17": 
            case "1.17.1": {
                this.nmsHandler = new NMSHandler_v1_17_R1();
                break;
            }
            case "1.18": 
            case "1.18.1": {
                this.nmsHandler = new NMSHandler_v1_18_R1();
                break;
            }
            case "1.18.2": {
                this.nmsHandler = new NMSHandler_v1_18_R2();
                break;
            }
            case "1.19": 
            case "1.19.1": 
            case "1.19.2": {
                this.nmsHandler = new NMSHandler_v1_19_R1();
                break;
            }
            case "1.19.3": {
                this.nmsHandler = new NMSHandler_v1_19_R2();
                break;
            }
            case "1.19.4": {
                this.nmsHandler = new NMSHandler_v1_19_R3();
                break;
            }
            case "1.20": 
            case "1.20.1": {
                this.nmsHandler = new NMSHandler_v1_20_R1();
                break;
            }
            case "1.20.2": {
                this.nmsHandler = new NMSHandler_v1_20_R2();
                break;
            }
            case "1.20.3": 
            case "1.20.4": {
                this.nmsHandler = new NMSHandler_v1_20_R3();
                break;
            }
            case "1.20.5": 
            case "1.20.6": {
                this.nmsHandler = new NMSHandler_v1_20_R4();
                break;
            }
            case "1.21": 
            case "1.21.1": {
                this.nmsHandler = new NMSHandler_v1_21_R1();
                break;
            }
            case "1.21.2": 
            case "1.21.3": {
                this.nmsHandler = new NMSHandler_v1_21_R2();
                break;
            }
            case "1.21.4": {
                this.nmsHandler = new NMSHandler_v1_21_R3();
                break;
            }
            case "1.21.5": {
                this.nmsHandler = new NMSHandler_v1_21_R4();
                break;
            }
            case "1.21.7": 
            case "1.21.8": {
                this.nmsHandler = new NMSHandler_v1_21_R5();
            }
        }
        if (this.nmsHandler == null) {
            this.getLogger().severe("Your server version is not supported!");
            this.getLogger().severe("Please contact the developer to add support for your server version!");
            this.getLogger().severe("Discord Dev: https://discord.gg/9kY4guxtxF");
            this.getLogger().severe("The plugin will be disabled!");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return false;
        }
        return true;
    }

    private void loadNewMessages() {
        if (!this.config.contains("shift-rc-open-profile")) {
            this.config.set("shift-rc-open-profile", true);
        }
        this.shiftOpenProfile = this.config.getBoolean("shift-rc-open-profile");
        if (!this.config.contains("messages.player-profile-not-public")) {
            this.config.set("messages.player-profile-not-public", "&4The profile of the player you are trying to access is private.");
        }
        if (!this.config.contains("messages.profile-mode-toggle.private")) {
            this.config.set("messages.profile-mode-toggle.private", "&cYour profile is now private, no one but you will be able to see it!");
        }
        if (!this.config.contains("messages.profile-mode-toggle.public")) {
            this.config.set("messages.profile-mode-toggle.public", "&aNow your profile is public, everyone can see it.");
        }
        this.config.save();
    }

    public void onDisable() {
        if (this.getSql() != null) {
            this.sql.savePlayers();
        }
        instance = null;
    }

    public PlayerData getPlayerData(Player player) {
        return PlayerData.getPlayer(player);
    }

    private void registerListeners() {
        PluginManager pluginManager = this.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)new JoinListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new QuitListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new InventoryListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new PlayerInteractListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new ServerLoadedListener(), (Plugin)this);
        if (this.existItemsAdder()) {
            pluginManager.registerEvents((Listener)new ItemsAdderListener(), (Plugin)this);
        }
        if (this.existNexo()) {
            pluginManager.registerEvents((Listener)new NexoListener(), (Plugin)this);
        }
    }

    private void registerCommands() {
        this.getCommand("playerprofile").setExecutor((CommandExecutor)new Command());
        this.getCommand("playerprofile").setTabCompleter((TabCompleter)new Command());
    }

    public static PlayerProfile getInstance() {
        return instance;
    }

    public SQL getSql() {
        return this.sql;
    }

    public FileCreator getConfig() {
        return this.config;
    }

    public FileMenus getMenus() {
        return this.menus;
    }

    public PlaceholderAPI getPlaceholderAPI() {
        return this.placeholderAPI;
    }

    public ItemsAdder getItemsAdder() {
        return this.itemsAdder;
    }

    public boolean existItemsAdder() {
        return this.itemsAdder != null;
    }

    public boolean existPlaceholderAPI() {
        return this.placeholderAPI != null;
    }

    public ECosmetics getECosmetics() {
        return this.ECosmetics;
    }

    public boolean existECosmetics() {
        return this.ECosmetics != null;
    }

    public MenuLoader getMenuLoader() {
        return this.menuLoader;
    }

    public void setItemsAdder(ItemsAdder itemsAdder) {
        this.itemsAdder = itemsAdder;
    }

    public void setECosmetics(ECosmetics ECosmetics2) {
        this.ECosmetics = ECosmetics2;
    }

    public void setPlaceholderAPI(PlaceholderAPI placeholderAPI) {
        this.placeholderAPI = placeholderAPI;
    }

    public void setMenuLoader(MenuLoader menuLoader) {
        this.menuLoader = menuLoader;
    }

    public boolean isOfflinePlayers() {
        return this.offlinePlayers;
    }

    public Nexo getNexo() {
        return this.nexo;
    }

    public boolean existNexo() {
        return this.nexo != null;
    }

    public void setNexo(Nexo nexo) {
        this.nexo = nexo;
    }

    public void setOfflinePlayers(boolean offlinePlayers) {
        this.offlinePlayers = offlinePlayers;
    }

    public boolean isShiftOpenProfile() {
        return this.shiftOpenProfile;
    }

    public void setShiftOpenProfile(boolean shiftOpenProfile) {
        this.shiftOpenProfile = shiftOpenProfile;
    }

    public String getDefaultStatus() {
        return this.defaultStatus;
    }

    public void setDefaultStatus(String defaultStatus) {
        this.defaultStatus = defaultStatus;
    }

    public FileCreator getStatus() {
        return this.status;
    }

    public FileCreator getTitleMenus() {
        return this.titleMenus;
    }

    public INMSHandler getNmsHandler() {
        return this.nmsHandler;
    }

    public void setNmsHandler(INMSHandler nmsHandler) {
        this.nmsHandler = nmsHandler;
    }
}

