/*
 * Decompiled with CFR 0.152.
 */
package ru.sculmix.playerprofile.commands;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import ru.sculmix.playerprofile.PlayerProfile;
import ru.sculmix.playerprofile.data.PlayerData;
import ru.sculmix.playerprofile.inventories.Menu;
import ru.sculmix.playerprofile.inventories.handlers.StatusMenu;

public class Command
implements CommandExecutor,
TabExecutor {
    private final PlayerProfile plugin = PlayerProfile.getInstance();

    public boolean onCommand(CommandSender sender, org.bukkit.command.Command command, String label, String[] args) {
        if (sender instanceof ConsoleCommandSender) {
            if (args.length > 0) {
                switch (args[0].toLowerCase()) {
                    case "help": {
                        this.sendHelp(sender);
                        return true;
                    }
                    case "reload": {
                        this.reload(sender);
                        return true;
                    }
                }
                if (args.length != 2) {
                    return true;
                }
                Player player = Bukkit.getPlayer((String)args[1]);
                if (player == null) {
                    sender.sendMessage(this.plugin.getConfig().getString("messages.prefix") + this.plugin.getConfig().getString("messages.console.first-player-offline"));
                    return true;
                }
                PlayerData playerData = PlayerData.getOfflinePlayer(args[0]);
                if (playerData == null) {
                    sender.sendMessage(this.plugin.getConfig().getString("messages.prefix") + this.plugin.getConfig().getString("messages.player-not-exist"));
                    return true;
                }
                if (!playerData.isOnline() && !this.plugin.isOfflinePlayers()) {
                    sender.sendMessage(this.plugin.getConfig().getString("messages.prefix") + this.plugin.getConfig().getString("messages.offline-player"));
                    return true;
                }
                Player target = Bukkit.getPlayer((String)args[0]);
                if (target == null) {
                    this.plugin.getMenuLoader().getProfileMenu(player).create(this.plugin, playerData, player);
                    sender.sendMessage(this.plugin.getConfig().getString("messages.prefix") + this.plugin.getConfig().getString("messages.console.open-profile").replace("%player%", player.getName()));
                    return true;
                }
                this.plugin.getMenuLoader().getProfileMenu(player).create(this.plugin, playerData, player);
                sender.sendMessage(this.plugin.getConfig().getString("messages.prefix") + this.plugin.getConfig().getString("messages.console.open-profile").replace("%player%", player.getName()));
                return true;
            }
            this.sendHelp(sender);
            return true;
        }
        Player player = (Player)sender;
        if (args.length > 0) {
            switch (args[0].toLowerCase()) {
                case "help": {
                    this.sendHelp((CommandSender)player);
                    return true;
                }
                case "public-toggle": {
                    PlayerData playerData = PlayerData.getPlayer(player);
                    playerData.togglePublicProfile();
                    if (playerData.isPublicProfile()) {
                        player.sendMessage(this.plugin.getConfig().getString("messages.prefix") + this.plugin.getConfig().getString("messages.profile-mode-toggle.public"));
                    } else {
                        player.sendMessage(this.plugin.getConfig().getString("messages.prefix") + this.plugin.getConfig().getString("messages.profile-mode-toggle.private"));
                    }
                    return true;
                }
                case "change-status": {
                    PlayerData playerData = PlayerData.getPlayer(player);
                    StatusMenu statusMenu = this.plugin.getMenuLoader().getChangeStatusMenu();
                    if (statusMenu == null) {
                        return true;
                    }
                    statusMenu.create(this.plugin, playerData, null);
                    return true;
                }
                case "reload": {
                    this.reload((CommandSender)player);
                    return true;
                }
            }
            if (args.length >= 2) {
                if (!player.hasPermission("playerprofile.open.others")) {
                    player.sendMessage(this.plugin.getConfig().getString("messages.prefix") + this.plugin.getConfig().getString("messages.no-permission"));
                    return true;
                }
                Player target = Bukkit.getPlayer((String)args[1]);
                if (target == null) {
                    player.sendMessage(this.plugin.getConfig().getString("messages.prefix") + this.plugin.getConfig().getString("messages.console.first-player-offline"));
                    return true;
                }
                PlayerData playerData = PlayerData.getOfflinePlayer(args[0]);
                if (playerData == null) {
                    player.sendMessage(this.plugin.getConfig().getString("messages.prefix") + this.plugin.getConfig().getString("messages.player-not-exist"));
                    return true;
                }
                if (!playerData.isOnline() && !this.plugin.isOfflinePlayers()) {
                    player.sendMessage(this.plugin.getConfig().getString("messages.prefix") + this.plugin.getConfig().getString("messages.offline-player"));
                    return true;
                }
                Menu<?> menu = this.plugin.getMenuLoader().getProfileMenu(target);
                menu.create(this.plugin, playerData, target);
                player.sendMessage(this.plugin.getConfig().getString("messages.prefix") + this.plugin.getConfig().getString("messages.console.open-profile").replace("%player%", target.getName()));
                return true;
            }
            Object playerData = PlayerData.getOfflinePlayer(args[0]);
            if (playerData == null) {
                player.sendMessage(this.plugin.getConfig().getString("messages.prefix") + this.plugin.getConfig().getString("messages.player-not-exist"));
                return true;
            }
            if (!((PlayerData)playerData).isOnline() && !this.plugin.isOfflinePlayers()) {
                player.sendMessage(this.plugin.getConfig().getString("messages.prefix") + this.plugin.getConfig().getString("messages.offline-player"));
                return true;
            }
            this.plugin.getMenuLoader().getProfileMenu(player).create(this.plugin, (PlayerData)playerData, player);
            return true;
        }
        this.plugin.getMenuLoader().getProfileMenu(player).create(this.plugin, PlayerData.getPlayer(player), player);
        return true;
    }

    public void reload(CommandSender sender) {
        if (!sender.hasPermission("playerprofile.*")) {
            sender.sendMessage(this.plugin.getConfig().getString("messages.prefix") + this.plugin.getConfig().getString("messages.no-permission"));
            return;
        }
        this.plugin.getConfig().reload();
        this.plugin.getStatus().reload();
        this.plugin.getMenus().reloadFiles();
        this.plugin.getMenuLoader().loadStatusMenu();
        this.plugin.getMenuLoader().load();
        this.plugin.setOfflinePlayers(this.plugin.getConfig().getBoolean("offline-players"));
        this.plugin.setShiftOpenProfile(this.plugin.getConfig().getBoolean("shift-rc-open-profile"));
        this.plugin.setDefaultStatus(this.plugin.getStatus().getString("default-status"));
        sender.sendMessage(this.plugin.getConfig().getString("messages.prefix") + this.plugin.getConfig().getString("messages.reload"));
    }

    public void sendHelp(CommandSender sender) {
        if (!sender.hasPermission("playerprofile.*")) {
            for (String line : this.plugin.getConfig().getStringList("messages.help-user")) {
                sender.sendMessage(line);
            }
            return;
        }
        for (String line : this.plugin.getConfig().getStringList("messages.help-staff")) {
            sender.sendMessage(line);
        }
    }

    public List<String> onTabComplete(CommandSender sender, org.bukkit.command.Command command, String label, String[] args) {
        ArrayList<String> arguments = new ArrayList<String>();
        if (args.length == 2) {
            return null;
        }
        if (args.length > 2) {
            return arguments;
        }
        arguments.add("help");
        arguments.add("public-toggle");
        if (sender.hasPermission("playerprofile.*")) {
            arguments.add("reload");
        }
        arguments.addAll(PlayerData.allPlayers.keySet());
        ArrayList<String> result = new ArrayList<String>();
        for (String arg : arguments) {
            if (arg == null || arg.isEmpty() || !arg.toLowerCase().startsWith(args[0].toLowerCase())) continue;
            result.add(arg);
        }
        return result;
    }
}

