/*
 * Decompiled with CFR 0.152.
 */
package ru.sculmix.playerprofile.data;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import ru.sculmix.playerprofile.PlayerProfile;
import ru.sculmix.playerprofile.data.PlayerEquipment;
import ru.sculmix.playerprofile.inventories.Menu;
import ru.sculmix.playerprofile.inventories.handlers.StatusMenu;
import ru.sculmix.playerprofile.utils.Utils;

public class PlayerData {
    private final UUID uniqueId;
    private final String playerName;
    private final PlayerEquipment equipment;
    private boolean online;
    private boolean publicProfile;
    private Menu menu;
    private StatusMenu statusMenu;
    public static final Map<String, UUID> allPlayers = new HashMap<String, UUID>();
    public static final Map<UUID, PlayerData> players = new HashMap<UUID, PlayerData>();
    private OfflinePlayer offlinePlayer;
    private String status;
    private final Map<Integer, ItemStack> itemsSaved;

    public PlayerData(Player player) {
        this(player.getUniqueId(), player.getName());
    }

    public PlayerData(UUID uniqueId, String playerName) {
        this.offlinePlayer = Bukkit.getOfflinePlayer((UUID)uniqueId);
        this.uniqueId = uniqueId;
        this.playerName = playerName;
        this.equipment = new PlayerEquipment(this);
        this.publicProfile = true;
        this.itemsSaved = new HashMap<Integer, ItemStack>();
        this.status = PlayerProfile.getInstance().getDefaultStatus();
    }

    public static PlayerData getExistPlayer(Player player) {
        return players.get(player.getUniqueId());
    }

    public static PlayerData getPlayer(Player player) {
        if (!players.containsKey(player.getUniqueId())) {
            PlayerData playerData = new PlayerData(player);
            players.put(player.getUniqueId(), playerData);
            allPlayers.put(player.getName(), player.getUniqueId());
            return playerData;
        }
        return players.get(player.getUniqueId());
    }

    public static PlayerData getOfflinePlayer(String player) {
        if (!allPlayers.containsKey(player)) {
            return null;
        }
        UUID uniqueId = allPlayers.get(player);
        return players.get(uniqueId);
    }

    public static PlayerData addOfflinePlayer(String uuid, String playerName) {
        UUID uniqueId = UUID.fromString(uuid);
        if (!players.containsKey(uniqueId)) {
            PlayerData playerData = new PlayerData(uniqueId, playerName);
            players.put(uniqueId, playerData);
            allPlayers.put(playerName, uniqueId);
            return playerData;
        }
        return players.get(uniqueId);
    }

    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public void setOfflinePlayer(OfflinePlayer offlinePlayer) {
        this.offlinePlayer = offlinePlayer;
    }

    public OfflinePlayer getOfflinePlayer() {
        return this.offlinePlayer;
    }

    public PlayerEquipment getEquipment() {
        return this.equipment;
    }

    public void setMenu(Menu menu) {
        this.menu = menu;
    }

    public Menu getMenu() {
        return this.menu;
    }

    public void returnToMenuCancel() {
        this.setStatusMenu(null);
        Menu menu = this.getMenu();
        if (menu == null) {
            this.getOfflinePlayer().getPlayer().closeInventory();
            return;
        }
        this.getOfflinePlayer().getPlayer().openInventory(menu.getInventory());
    }

    public void returnToMenuSuccess() {
        this.setStatusMenu(null);
        Menu menu = this.getMenu();
        if (menu == null) {
            this.getOfflinePlayer().getPlayer().closeInventory();
            return;
        }
        menu.update();
        this.getOfflinePlayer().getPlayer().openInventory(menu.getInventory());
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public void setOnline(boolean online) {
        this.online = online;
    }

    public boolean isPublicProfile() {
        return this.publicProfile;
    }

    public void togglePublicProfile() {
        this.publicProfile = !this.publicProfile;
    }

    public void setPublicProfile(boolean publicProfile) {
        this.publicProfile = publicProfile;
    }

    public boolean isOnline() {
        return this.online;
    }

    public void openBookDescription() {
        Player player = this.getOfflinePlayer().getPlayer();
        if (player == null) {
            return;
        }
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setStatusMenu(StatusMenu statusMenu) {
        this.statusMenu = statusMenu;
    }

    public StatusMenu getStatusMenu() {
        return this.statusMenu;
    }

    public Map<Integer, ItemStack> getItemsSaved() {
        return this.itemsSaved;
    }

    public void removeItemSaved(int slot) {
        this.itemsSaved.remove(slot);
    }

    public void addItemSaved(int slot, ItemStack itemSaved) {
        this.itemsSaved.put(slot, itemSaved);
    }

    public String getItemsSavedSerialized() {
        if (this.itemsSaved.isEmpty()) {
            return "";
        }
        return Utils.serializeInventoryToBase64(this.itemsSaved);
    }

    public void loadItemsSavedDeserialized(String items) {
        if (items.isEmpty()) {
            return;
        }
        Map<Integer, ItemStack> itemStackMap = Utils.deserializeInventoryFromBase64(items);
        if (itemStackMap == null) {
            return;
        }
        this.itemsSaved.putAll(itemStackMap);
    }
}

