/*
 * Decompiled with CFR 0.152.
 */
package ru.sculmix.playerprofile.data;

import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import ru.sculmix.playerprofile.PlayerProfile;
import ru.sculmix.playerprofile.data.PlayerData;

public class PlayerEquipment {
    private final PlayerData playerData;
    private ItemStack helmet;
    private ItemStack chestPlate;
    private ItemStack leggings;
    private ItemStack boots;
    private ItemStack hat;
    private ItemStack backpack;
    private ItemStack offhand;
    private ItemStack balloon;
    private ItemStack spray;

    public PlayerEquipment(PlayerData playerData) {
        this(playerData, null, null, null, null);
    }

    public PlayerEquipment(PlayerData playerData, ItemStack helmet, ItemStack chestPlate, ItemStack leggings, ItemStack boots) {
        this.playerData = playerData;
        this.helmet = helmet;
        this.chestPlate = chestPlate;
        this.leggings = leggings;
        this.boots = boots;
    }

    public void update() {
        Player player = this.playerData.getOfflinePlayer().getPlayer();
        if (player == null) {
            return;
        }
        EntityEquipment entityEquipment = player.getEquipment();
        this.helmet = entityEquipment.getHelmet();
        this.chestPlate = entityEquipment.getChestplate();
        this.leggings = entityEquipment.getLeggings();
        this.boots = entityEquipment.getBoots();
        PlayerProfile plugin = PlayerProfile.getInstance();
        if (!plugin.existECosmetics()) {
            return;
        }
        this.helmet = plugin.getECosmetics().getHelmet((OfflinePlayer)player);
        this.hat = plugin.getECosmetics().getHat((OfflinePlayer)player);
        this.backpack = plugin.getECosmetics().getBackPack((OfflinePlayer)player);
        this.offhand = plugin.getECosmetics().getOffHand((OfflinePlayer)player);
        this.balloon = plugin.getECosmetics().getBalloon((OfflinePlayer)player);
        this.spray = plugin.getECosmetics().getSpray((OfflinePlayer)player);
    }

    public void update(ItemStack helmet, ItemStack chestPlate, ItemStack leggings, ItemStack boots, ItemStack hat, ItemStack backpack, ItemStack offhand, ItemStack balloon, ItemStack spray) {
        this.helmet = helmet;
        this.chestPlate = chestPlate;
        this.leggings = leggings;
        this.boots = boots;
        PlayerProfile plugin = PlayerProfile.getInstance();
        if (!plugin.existECosmetics()) {
            return;
        }
        this.hat = hat;
        this.backpack = backpack;
        this.offhand = offhand;
        this.balloon = balloon;
        this.spray = spray;
    }

    public ItemStack getHelmet() {
        return this.helmet;
    }

    public ItemStack getChestPlate() {
        return this.chestPlate;
    }

    public ItemStack getLeggings() {
        return this.leggings;
    }

    public ItemStack getBoots() {
        return this.boots;
    }

    public ItemStack getHat() {
        return this.hat;
    }

    public ItemStack getBackpack() {
        return this.backpack;
    }

    public ItemStack getOffhand() {
        return this.offhand;
    }

    public ItemStack getBalloon() {
        return this.balloon;
    }

    public ItemStack getSpray() {
        return this.spray;
    }
}

