/*
 * Decompiled with CFR 0.152.
 */
package ru.sculmix.playerprofile.database;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import ru.sculmix.playerprofile.database.DatabaseType;
import ru.sculmix.playerprofile.database.SQL;
import ru.sculmix.playerprofile.database.SQLite;

public class HikariCP {
    private HikariDataSource hikariDataSource;
    protected String hostname;
    protected int port;
    protected String database;
    protected String username;
    protected String password;

    public HikariCP(String hostname, int port, String username, String password, String database) {
        this.hostname = hostname;
        this.port = port;
        this.username = username;
        this.database = database;
        this.password = password;
    }

    public void setProperties(SQL sql) {
        HikariConfig config = new HikariConfig();
        if (sql.getDatabaseType() == DatabaseType.MYSQL) {
            String mysql = "jdbc:mysql://" + this.hostname + ":" + this.port + "/" + this.database;
            config.setJdbcUrl(mysql);
            config.setUsername(this.username);
            config.setPassword(this.password);
            config.addDataSourceProperty("cachePrepStmts", "true");
            config.addDataSourceProperty("prepStmtCacheSize", "250");
            config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
            config.setMaximumPoolSize(10);
            config.setConnectionTimeout(30000L);
            config.setDriverClassName("com.mysql.cj.jdbc.Driver");
        } else {
            String sqlite = "jdbc:sqlite:" + String.valueOf(((SQLite)sql).getFileSQL());
            config.setJdbcUrl(sqlite);
            config.setDriverClassName("org.sqlite.JDBC");
        }
        this.hikariDataSource = new HikariDataSource(config);
    }

    public HikariCP() {
    }

    public HikariDataSource getHikariDataSource() {
        return this.hikariDataSource;
    }
}

