/*
 * Decompiled with CFR 0.152.
 */
package ru.sculmix.playerprofile.database;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import ru.sculmix.playerprofile.data.PlayerData;
import ru.sculmix.playerprofile.database.DatabaseType;
import ru.sculmix.playerprofile.database.HikariCP;
import ru.sculmix.playerprofile.database.SQL;
import ru.sculmix.playerprofile.utils.Utils;

public class SQLite
extends SQL {
    private final File fileSQL;

    public SQLite() {
        this.hikariCP = new HikariCP();
        this.fileSQL = new File(this.plugin.getDataFolder(), "players.db");
        this.hikariCP.setProperties(this);
        this.createTable();
    }

    @Override
    public void createTable() {
        String sql = "CREATE TABLE IF NOT EXISTS players (id INTEGER PRIMARY KEY AUTOINCREMENT, UniqueId VARCHAR(255), PlayerName VARCHAR(255), Helmet LONGTEXT, ChestPlate LONGTEXT, Leggings LONGTEXT, Boots LONGTEXT, Hat LONGTEXT, Backpack LONGTEXT, Offhand LONGTEXT, Balloon LONGTEXT, Spray LONGTEXT, Status VARCHAR(255), PublicProfile BOOLEAN, ItemsSaved LONGTEXT)";
        try (Connection connection = this.hikariCP.getHikariDataSource().getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            preparedStatement.executeUpdate();
            this.plugin.getLogger().info("SQLite table created successfully");
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Could not create table: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void loadPlayersAsync() {
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            this.plugin.getLogger().info("Loading players...");
            String sql = "SELECT * FROM players";
            try (Connection connection = this.hikariCP.getHikariDataSource().getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement(sql);
                 ResultSet resultSet = preparedStatement.executeQuery();){
                int i = 0;
                while (resultSet.next()) {
                    String uniqueId = resultSet.getString("UniqueId");
                    String playerName = resultSet.getString("PlayerName");
                    String helmet = resultSet.getString("Helmet");
                    String chestplate = resultSet.getString("ChestPlate");
                    String leggings = resultSet.getString("Leggings");
                    String boots = resultSet.getString("Boots");
                    String hat = resultSet.getString("Hat");
                    String backpack = resultSet.getString("Backpack");
                    String offhand = resultSet.getString("Offhand");
                    String balloon = resultSet.getString("Balloon");
                    String spray = resultSet.getString("Spray");
                    String status = resultSet.getString("Status");
                    boolean publicProfile = resultSet.getBoolean("PublicProfile");
                    String items = resultSet.getString("ItemsSaved");
                    PlayerData.allPlayers.put(playerName, UUID.fromString(uniqueId));
                    PlayerData playerData = PlayerData.addOfflinePlayer(uniqueId, playerName);
                    if (playerData == null) {
                        this.plugin.getLogger().severe("Could not load player data: " + playerName);
                        continue;
                    }
                    playerData.setOnline(false);
                    playerData.setStatus(status);
                    playerData.setPublicProfile(publicProfile);
                    playerData.getEquipment().update(Utils.itemStackFromBase64(helmet), Utils.itemStackFromBase64(chestplate), Utils.itemStackFromBase64(leggings), Utils.itemStackFromBase64(boots), Utils.itemStackFromBase64(hat), Utils.itemStackFromBase64(backpack), Utils.itemStackFromBase64(offhand), Utils.itemStackFromBase64(balloon), Utils.itemStackFromBase64(spray));
                    playerData.loadItemsSavedDeserialized(items);
                    ++i;
                }
                this.plugin.getLogger().info("Loaded " + i + " players");
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Could not load players: " + e.getMessage());
                e.printStackTrace();
            }
        });
    }

    @Override
    public DatabaseType getDatabaseType() {
        return DatabaseType.SQLITE;
    }

    @Override
    public void savePlayer(Player player, boolean async) {
        PlayerData playerData = PlayerData.getPlayer(player);
        playerData.getEquipment().update();
        playerData.setOfflinePlayer(Bukkit.getOfflinePlayer((UUID)playerData.getUniqueId()));
        playerData.setOnline(false);
        Runnable saveTask = () -> {
            String query = !this.checkInfo(playerData) ? "INSERT INTO players (id, UniqueId, PlayerName, Helmet, ChestPlate, Leggings, Boots, Hat, Backpack, Offhand, Balloon, Spray, Status, PublicProfile, ItemsSaved) VALUES(NULL, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);" : "UPDATE players SET PlayerName = ?, Helmet = ?, ChestPlate = ?, Leggings = ?, Boots = ?, Hat = ?, Backpack = ?, Offhand = ?, Balloon = ?, Spray = ?, Status = ?, PublicProfile = ?, ItemsSaved = ? WHERE UniqueId = ?";
            try (Connection connection = this.hikariCP.getHikariDataSource().getConnection();
                 PreparedStatement ps = connection.prepareStatement(query);){
                if (!this.checkInfo(playerData)) {
                    ps.setString(1, playerData.getUniqueId().toString());
                    ps.setString(2, playerData.getPlayerName());
                    ps.setString(3, playerData.getEquipment().getHelmet() == null ? "" : Utils.itemStackToBase64(playerData.getEquipment().getHelmet()));
                    ps.setString(4, playerData.getEquipment().getChestPlate() == null ? "" : Utils.itemStackToBase64(playerData.getEquipment().getChestPlate()));
                    ps.setString(5, playerData.getEquipment().getLeggings() == null ? "" : Utils.itemStackToBase64(playerData.getEquipment().getLeggings()));
                    ps.setString(6, playerData.getEquipment().getBoots() == null ? "" : Utils.itemStackToBase64(playerData.getEquipment().getBoots()));
                    ps.setString(7, playerData.getEquipment().getHat() == null ? "" : Utils.itemStackToBase64(playerData.getEquipment().getHat()));
                    ps.setString(8, playerData.getEquipment().getBackpack() == null ? "" : Utils.itemStackToBase64(playerData.getEquipment().getBackpack()));
                    ps.setString(9, playerData.getEquipment().getOffhand() == null ? "" : Utils.itemStackToBase64(playerData.getEquipment().getOffhand()));
                    ps.setString(10, playerData.getEquipment().getBalloon() == null ? "" : Utils.itemStackToBase64(playerData.getEquipment().getBalloon()));
                    ps.setString(11, playerData.getEquipment().getSpray() == null ? "" : Utils.itemStackToBase64(playerData.getEquipment().getSpray()));
                    ps.setString(12, playerData.getStatus());
                    ps.setBoolean(13, playerData.isPublicProfile());
                    ps.setString(14, playerData.getItemsSavedSerialized());
                } else {
                    ps.setString(1, playerData.getPlayerName());
                    ps.setString(2, playerData.getEquipment().getHelmet() == null ? "" : Utils.itemStackToBase64(playerData.getEquipment().getHelmet()));
                    ps.setString(3, playerData.getEquipment().getChestPlate() == null ? "" : Utils.itemStackToBase64(playerData.getEquipment().getChestPlate()));
                    ps.setString(4, playerData.getEquipment().getLeggings() == null ? "" : Utils.itemStackToBase64(playerData.getEquipment().getLeggings()));
                    ps.setString(5, playerData.getEquipment().getBoots() == null ? "" : Utils.itemStackToBase64(playerData.getEquipment().getBoots()));
                    ps.setString(6, playerData.getEquipment().getHat() == null ? "" : Utils.itemStackToBase64(playerData.getEquipment().getHat()));
                    ps.setString(7, playerData.getEquipment().getBackpack() == null ? "" : Utils.itemStackToBase64(playerData.getEquipment().getBackpack()));
                    ps.setString(8, playerData.getEquipment().getOffhand() == null ? "" : Utils.itemStackToBase64(playerData.getEquipment().getOffhand()));
                    ps.setString(9, playerData.getEquipment().getBalloon() == null ? "" : Utils.itemStackToBase64(playerData.getEquipment().getBalloon()));
                    ps.setString(10, playerData.getEquipment().getSpray() == null ? "" : Utils.itemStackToBase64(playerData.getEquipment().getSpray()));
                    ps.setString(11, playerData.getStatus());
                    ps.setBoolean(12, playerData.isPublicProfile());
                    ps.setString(13, playerData.getItemsSavedSerialized());
                    ps.setString(14, playerData.getUniqueId().toString());
                }
                ps.executeUpdate();
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Failed to save player information: " + e.getMessage());
                e.printStackTrace();
            }
        };
        if (async) {
            this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, saveTask);
        } else {
            saveTask.run();
        }
    }

    @Override
    public void savePlayers() {
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            PlayerData playerData = PlayerData.getExistPlayer(player);
            if (playerData == null) continue;
            this.savePlayer(player, false);
        }
    }

    /*
     * Exception decompiling
     */
    private boolean checkInfo(PlayerData playerData) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public File getFileSQL() {
        return this.fileSQL;
    }
}

