/*
 * Decompiled with CFR 0.152.
 */
package ru.sculmix.playerprofile.files;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import ru.sculmix.playerprofile.utils.Utils;

public class FileCreator
extends YamlConfiguration {
    private final String fileName;
    private final Plugin plugin;
    private final File file;

    public FileCreator(Plugin plugin, String filename, String fileExtension, File folder) {
        this.plugin = plugin;
        this.fileName = filename + (filename.endsWith(fileExtension) ? "" : fileExtension);
        this.file = new File(folder, this.fileName);
        this.createFile();
    }

    public FileCreator(Plugin plugin, String fileName) {
        this(plugin, fileName, ".yml");
    }

    public FileCreator(Plugin plugin, String fileName, String fileExtension) {
        this(plugin, fileName, fileExtension, plugin.getDataFolder());
    }

    private void createFile() {
        try {
            if (!this.fileName.endsWith(".yml") && !this.file.exists()) {
                if (this.plugin.getResource(this.fileName) != null) {
                    this.plugin.saveResource(this.fileName, false);
                }
                return;
            }
            if (!this.file.exists()) {
                if (this.plugin.getResource(this.fileName) != null) {
                    this.plugin.saveResource(this.fileName, false);
                } else {
                    this.save(this.file);
                }
                this.load(this.file);
                return;
            }
            this.load(this.file);
            this.save(this.file);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void saveDefault() {
        this.plugin.saveResource(this.fileName, false);
    }

    public void save() {
        try {
            this.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Save of the file '" + this.fileName + "' failed.", e);
        }
    }

    public void reload() {
        try {
            this.load(this.file);
        }
        catch (IOException | InvalidConfigurationException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Reload of the file '" + this.fileName + "' failed.", e);
        }
    }

    public String getStringWF(String path) {
        return super.getString(path, "");
    }

    public String getString(String path) {
        String value = super.getString(path);
        return value != null ? Utils.ChatColor(value) : null;
    }

    public List<String> getStringList(String path) {
        List list = super.getStringList(path);
        if (list != null) {
            list.replaceAll(Utils::ChatColor);
        }
        return list;
    }

    public List<String> getStringListWF(String path) {
        return super.getStringList(path);
    }

    public String getString(String path, String def) {
        String value = super.getString(path, def);
        return value != null ? Utils.ChatColor(value) : def;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getName() {
        String name = this.fileName.replace(".yml", "");
        return name.substring(name.lastIndexOf("/") + 1);
    }
}

