/*
 * Decompiled with CFR 0.152.
 */
package ru.sculmix.playerprofile.files;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.plugin.Plugin;
import ru.sculmix.playerprofile.PlayerProfile;
import ru.sculmix.playerprofile.files.FileCreator;

public class FileMenus {
    private final PlayerProfile plugin = PlayerProfile.getInstance();
    private final Map<String, FileCreator> files = new ConcurrentHashMap<String, FileCreator>();

    public FileMenus() {
        this.loadFiles();
    }

    public Map<String, FileCreator> getFiles() {
        return this.files;
    }

    public FileCreator getFile(String name) {
        return this.files.get(name);
    }

    public void loadFiles() {
        File path = new File(this.plugin.getDataFolder(), "menus");
        if (!path.exists()) {
            this.plugin.getLogger().info("Loading menu file: menu.yml");
            this.files.put("menus/menu.yml", new FileCreator((Plugin)this.plugin, "menus/menu"));
            return;
        }
        for (File file : path.listFiles()) {
            this.plugin.getLogger().info("Loading menu file: " + file.getName());
            this.files.put(file.getName(), new FileCreator((Plugin)this.plugin, "menus/" + file.getName()));
        }
    }

    public void loadFile(String name) {
        name = ((String)name).endsWith(".yml") ? name : (String)name + ".yml";
        this.plugin.getLogger().info("Loading menu file: " + (String)name);
        this.files.put((String)name, new FileCreator((Plugin)this.plugin, "menus/" + (String)name));
    }

    public void saveFiles() {
        for (FileCreator file : this.files.values()) {
            this.plugin.getLogger().info("Saving menu file: " + file.getFileName());
            file.save();
        }
    }

    public void saveFile(String name) {
        name = ((String)name).endsWith(".yml") ? name : (String)name + ".yml";
        this.plugin.getLogger().info("Saving menu file: " + (String)name);
        this.files.get(name).save();
    }

    public void reloadFiles() {
        File path = new File(this.plugin.getDataFolder(), "menus");
        if (!path.exists()) {
            this.plugin.getLogger().info("Loading menu file: menu.yml");
            this.files.put("menus/menu.yml", new FileCreator((Plugin)this.plugin, "menus/menu"));
            return;
        }
        for (FileCreator file : this.files.values()) {
            if (!file.exists()) {
                this.deleteFile(file.getFileName());
                continue;
            }
            this.plugin.getLogger().info("Reloading menu file: " + file.getFileName());
            file.reload();
        }
        for (File file : path.listFiles()) {
            if (this.files.containsKey(file.getName())) continue;
            this.loadFile(file.getName());
        }
    }

    public void reloadFile(String name) {
        name = ((String)name).endsWith(".yml") ? name : (String)name + ".yml";
        this.plugin.getLogger().info("Reloading menu file: " + (String)name);
        this.files.get(name).reload();
    }

    public void deleteFile(String name) {
        if (((String)name).contains("/")) {
            name = ((String)name).split("/")[1];
        }
        name = ((String)name).endsWith(".yml") ? name : (String)name + ".yml";
        this.plugin.getLogger().info("Deleting menu file: " + (String)name);
        this.files.remove(name);
    }
}

